/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = DeleteContextResponse.Builder.class
)
public final class DeleteContextResponse {
  private final Optional<String> message;

  private final Optional<List<String>> unboundRules;

  private final Optional<List<String>> unboundFlows;

  private final Optional<Integer> pendingEvaluationsCancelled;

  private final Map<String, Object> additionalProperties;

  private DeleteContextResponse(Optional<String> message, Optional<List<String>> unboundRules,
      Optional<List<String>> unboundFlows, Optional<Integer> pendingEvaluationsCancelled,
      Map<String, Object> additionalProperties) {
    this.message = message;
    this.unboundRules = unboundRules;
    this.unboundFlows = unboundFlows;
    this.pendingEvaluationsCancelled = pendingEvaluationsCancelled;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Success message.
   */
  @JsonProperty("message")
  public Optional<String> getMessage() {
    return message;
  }

  /**
   * @return Slugs of rules that were unbound from the deleted context.
   */
  @JsonProperty("unbound_rules")
  public Optional<List<String>> getUnboundRules() {
    return unboundRules;
  }

  /**
   * @return Slugs of flows that were unbound from the deleted context.
   */
  @JsonProperty("unbound_flows")
  public Optional<List<String>> getUnboundFlows() {
    return unboundFlows;
  }

  /**
   * @return Number of pending evaluations that were cancelled when the context was deleted.
   */
  @JsonProperty("pending_evaluations_cancelled")
  public Optional<Integer> getPendingEvaluationsCancelled() {
    return pendingEvaluationsCancelled;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof DeleteContextResponse && equalTo((DeleteContextResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(DeleteContextResponse other) {
    return message.equals(other.message) && unboundRules.equals(other.unboundRules) && unboundFlows.equals(other.unboundFlows) && pendingEvaluationsCancelled.equals(other.pendingEvaluationsCancelled);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.message, this.unboundRules, this.unboundFlows, this.pendingEvaluationsCancelled);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> message = Optional.empty();

    private Optional<List<String>> unboundRules = Optional.empty();

    private Optional<List<String>> unboundFlows = Optional.empty();

    private Optional<Integer> pendingEvaluationsCancelled = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(DeleteContextResponse other) {
      message(other.getMessage());
      unboundRules(other.getUnboundRules());
      unboundFlows(other.getUnboundFlows());
      pendingEvaluationsCancelled(other.getPendingEvaluationsCancelled());
      return this;
    }

    /**
     * <p>Success message.</p>
     */
    @JsonSetter(
        value = "message",
        nulls = Nulls.SKIP
    )
    public Builder message(Optional<String> message) {
      this.message = message;
      return this;
    }

    public Builder message(String message) {
      this.message = Optional.ofNullable(message);
      return this;
    }

    /**
     * <p>Slugs of rules that were unbound from the deleted context.</p>
     */
    @JsonSetter(
        value = "unbound_rules",
        nulls = Nulls.SKIP
    )
    public Builder unboundRules(Optional<List<String>> unboundRules) {
      this.unboundRules = unboundRules;
      return this;
    }

    public Builder unboundRules(List<String> unboundRules) {
      this.unboundRules = Optional.ofNullable(unboundRules);
      return this;
    }

    /**
     * <p>Slugs of flows that were unbound from the deleted context.</p>
     */
    @JsonSetter(
        value = "unbound_flows",
        nulls = Nulls.SKIP
    )
    public Builder unboundFlows(Optional<List<String>> unboundFlows) {
      this.unboundFlows = unboundFlows;
      return this;
    }

    public Builder unboundFlows(List<String> unboundFlows) {
      this.unboundFlows = Optional.ofNullable(unboundFlows);
      return this;
    }

    /**
     * <p>Number of pending evaluations that were cancelled when the context was deleted.</p>
     */
    @JsonSetter(
        value = "pending_evaluations_cancelled",
        nulls = Nulls.SKIP
    )
    public Builder pendingEvaluationsCancelled(Optional<Integer> pendingEvaluationsCancelled) {
      this.pendingEvaluationsCancelled = pendingEvaluationsCancelled;
      return this;
    }

    public Builder pendingEvaluationsCancelled(Integer pendingEvaluationsCancelled) {
      this.pendingEvaluationsCancelled = Optional.ofNullable(pendingEvaluationsCancelled);
      return this;
    }

    public DeleteContextResponse build() {
      return new DeleteContextResponse(message, unboundRules, unboundFlows, pendingEvaluationsCancelled, additionalProperties);
    }
  }
}
