/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.rulebricks.core.ObjectMappers;
import java.io.IOException;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.IllegalStateException;
import java.lang.Object;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(
    using = DynamicValueValue.Deserializer.class
)
public final class DynamicValueValue {
  private final Object value;

  private final int type;

  private DynamicValueValue(Object value, int type) {
    this.value = value;
    this.type = type;
  }

  @JsonValue
  public Object get() {
    return this.value;
  }

  @SuppressWarnings("unchecked")
  public <T> T visit(Visitor<T> visitor) {
    if(this.type == 0) {
      return visitor.visit((String) this.value);
    } else if(this.type == 1) {
      return visitor.visit((double) this.value);
    } else if(this.type == 2) {
      return visitor.visit((boolean) this.value);
    } else if(this.type == 3) {
      return visitor.visit((List<Object>) this.value);
    } else if(this.type == 4) {
      return visitor.visit((Map<String, Object>) this.value);
    }
    throw new IllegalStateException("Failed to visit value. This should never happen.");
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof DynamicValueValue && equalTo((DynamicValueValue) other);
  }

  private boolean equalTo(DynamicValueValue other) {
    return value.equals(other.value);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.value);
  }

  @java.lang.Override
  public String toString() {
    return this.value.toString();
  }

  public static DynamicValueValue of(String value) {
    return new DynamicValueValue(value, 0);
  }

  public static DynamicValueValue of(double value) {
    return new DynamicValueValue(value, 1);
  }

  public static DynamicValueValue of(boolean value) {
    return new DynamicValueValue(value, 2);
  }

  public static DynamicValueValue of(List<Object> value) {
    return new DynamicValueValue(value, 3);
  }

  public static DynamicValueValue of(Map<String, Object> value) {
    return new DynamicValueValue(value, 4);
  }

  public interface Visitor<T> {
    T visit(String value);

    T visit(double value);

    T visit(boolean value);

    T visit(List<Object> value);

    T visit(Map<String, Object> value);
  }

  static final class Deserializer extends StdDeserializer<DynamicValueValue> {
    Deserializer() {
      super(DynamicValueValue.class);
    }

    @java.lang.Override
    public DynamicValueValue deserialize(JsonParser p, DeserializationContext context) throws
        IOException {
      Object value = p.readValueAs(Object.class);
      try {
        return of(ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
      } catch(RuntimeException e) {
      }
      if (value instanceof Double) {
        return of((Double) value);
      }
      if (value instanceof Boolean) {
        return of((Boolean) value);
      }
      try {
        return of(ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<List<Object>>() {}));
      } catch(RuntimeException e) {
      }
      try {
        return of(ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<Map<String, Object>>() {}));
      } catch(RuntimeException e) {
      }
      throw new JsonParseException(p, "Failed to deserialize");
    }
  }
}
