/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ExportManifestPreviewResponse.Builder.class
)
public final class ExportManifestPreviewResponse {
  private final Optional<Boolean> success;

  private final Optional<ExportManifestPreviewResponsePreview> preview;

  private final Optional<String> error;

  private final Map<String, Object> additionalProperties;

  private ExportManifestPreviewResponse(Optional<Boolean> success,
      Optional<ExportManifestPreviewResponsePreview> preview, Optional<String> error,
      Map<String, Object> additionalProperties) {
    this.success = success;
    this.preview = preview;
    this.error = error;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Whether the preview completed successfully.
   */
  @JsonProperty("success")
  public Optional<Boolean> getSuccess() {
    return success;
  }

  /**
   * @return Preview of assets that would be exported.
   */
  @JsonProperty("preview")
  public Optional<ExportManifestPreviewResponsePreview> getPreview() {
    return preview;
  }

  /**
   * @return Error message if preview failed.
   */
  @JsonProperty("error")
  public Optional<String> getError() {
    return error;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ExportManifestPreviewResponse && equalTo((ExportManifestPreviewResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ExportManifestPreviewResponse other) {
    return success.equals(other.success) && preview.equals(other.preview) && error.equals(other.error);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.success, this.preview, this.error);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Boolean> success = Optional.empty();

    private Optional<ExportManifestPreviewResponsePreview> preview = Optional.empty();

    private Optional<String> error = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ExportManifestPreviewResponse other) {
      success(other.getSuccess());
      preview(other.getPreview());
      error(other.getError());
      return this;
    }

    /**
     * <p>Whether the preview completed successfully.</p>
     */
    @JsonSetter(
        value = "success",
        nulls = Nulls.SKIP
    )
    public Builder success(Optional<Boolean> success) {
      this.success = success;
      return this;
    }

    public Builder success(Boolean success) {
      this.success = Optional.ofNullable(success);
      return this;
    }

    /**
     * <p>Preview of assets that would be exported.</p>
     */
    @JsonSetter(
        value = "preview",
        nulls = Nulls.SKIP
    )
    public Builder preview(Optional<ExportManifestPreviewResponsePreview> preview) {
      this.preview = preview;
      return this;
    }

    public Builder preview(ExportManifestPreviewResponsePreview preview) {
      this.preview = Optional.ofNullable(preview);
      return this;
    }

    /**
     * <p>Error message if preview failed.</p>
     */
    @JsonSetter(
        value = "error",
        nulls = Nulls.SKIP
    )
    public Builder error(Optional<String> error) {
      this.error = error;
      return this;
    }

    public Builder error(String error) {
      this.error = Optional.ofNullable(error);
      return this;
    }

    public ExportManifestPreviewResponse build() {
      return new ExportManifestPreviewResponse(success, preview, error, additionalProperties);
    }
  }
}
