/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ExportManifestResponse.Builder.class
)
public final class ExportManifestResponse {
  private final Optional<Boolean> success;

  private final Optional<ExportManifestResponseManifest> manifest;

  private final Optional<String> error;

  private final Map<String, Object> additionalProperties;

  private ExportManifestResponse(Optional<Boolean> success,
      Optional<ExportManifestResponseManifest> manifest, Optional<String> error,
      Map<String, Object> additionalProperties) {
    this.success = success;
    this.manifest = manifest;
    this.error = error;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Whether the export completed successfully.
   */
  @JsonProperty("success")
  public Optional<Boolean> getSuccess() {
    return success;
  }

  /**
   * @return The exported manifest data.
   */
  @JsonProperty("manifest")
  public Optional<ExportManifestResponseManifest> getManifest() {
    return manifest;
  }

  /**
   * @return Error message if export failed.
   */
  @JsonProperty("error")
  public Optional<String> getError() {
    return error;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ExportManifestResponse && equalTo((ExportManifestResponse) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ExportManifestResponse other) {
    return success.equals(other.success) && manifest.equals(other.manifest) && error.equals(other.error);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.success, this.manifest, this.error);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<Boolean> success = Optional.empty();

    private Optional<ExportManifestResponseManifest> manifest = Optional.empty();

    private Optional<String> error = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ExportManifestResponse other) {
      success(other.getSuccess());
      manifest(other.getManifest());
      error(other.getError());
      return this;
    }

    /**
     * <p>Whether the export completed successfully.</p>
     */
    @JsonSetter(
        value = "success",
        nulls = Nulls.SKIP
    )
    public Builder success(Optional<Boolean> success) {
      this.success = success;
      return this;
    }

    public Builder success(Boolean success) {
      this.success = Optional.ofNullable(success);
      return this;
    }

    /**
     * <p>The exported manifest data.</p>
     */
    @JsonSetter(
        value = "manifest",
        nulls = Nulls.SKIP
    )
    public Builder manifest(Optional<ExportManifestResponseManifest> manifest) {
      this.manifest = manifest;
      return this;
    }

    public Builder manifest(ExportManifestResponseManifest manifest) {
      this.manifest = Optional.ofNullable(manifest);
      return this;
    }

    /**
     * <p>Error message if export failed.</p>
     */
    @JsonSetter(
        value = "error",
        nulls = Nulls.SKIP
    )
    public Builder error(Optional<String> error) {
      this.error = error;
      return this;
    }

    public Builder error(String error) {
      this.error = Optional.ofNullable(error);
      return this;
    }

    public ExportManifestResponse build() {
      return new ExportManifestResponse(success, manifest, error, additionalProperties);
    }
  }
}
