/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = ExportManifestResponseManifest.Builder.class
)
public final class ExportManifestResponseManifest {
  private final Optional<String> version;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<OffsetDateTime> exportedAt;

  private final Optional<List<Map<String, Object>>> contexts;

  private final Optional<List<Map<String, Object>>> values;

  private final Optional<List<Map<String, Object>>> rules;

  private final Optional<List<Map<String, Object>>> flows;

  private final Map<String, Object> additionalProperties;

  private ExportManifestResponseManifest(Optional<String> version, Optional<String> name,
      Optional<String> description, Optional<OffsetDateTime> exportedAt,
      Optional<List<Map<String, Object>>> contexts, Optional<List<Map<String, Object>>> values,
      Optional<List<Map<String, Object>>> rules, Optional<List<Map<String, Object>>> flows,
      Map<String, Object> additionalProperties) {
    this.version = version;
    this.name = name;
    this.description = description;
    this.exportedAt = exportedAt;
    this.contexts = contexts;
    this.values = values;
    this.rules = rules;
    this.flows = flows;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Manifest format version.
   */
  @JsonProperty("version")
  public Optional<String> getVersion() {
    return version;
  }

  /**
   * @return Manifest name.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Manifest description.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  @JsonProperty("exported_at")
  public Optional<OffsetDateTime> getExportedAt() {
    return exportedAt;
  }

  /**
   * @return Exported contexts.
   */
  @JsonProperty("contexts")
  public Optional<List<Map<String, Object>>> getContexts() {
    return contexts;
  }

  /**
   * @return Exported dynamic values.
   */
  @JsonProperty("values")
  public Optional<List<Map<String, Object>>> getValues() {
    return values;
  }

  /**
   * @return Exported rules.
   */
  @JsonProperty("rules")
  public Optional<List<Map<String, Object>>> getRules() {
    return rules;
  }

  /**
   * @return Exported flows.
   */
  @JsonProperty("flows")
  public Optional<List<Map<String, Object>>> getFlows() {
    return flows;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof ExportManifestResponseManifest && equalTo((ExportManifestResponseManifest) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(ExportManifestResponseManifest other) {
    return version.equals(other.version) && name.equals(other.name) && description.equals(other.description) && exportedAt.equals(other.exportedAt) && contexts.equals(other.contexts) && values.equals(other.values) && rules.equals(other.rules) && flows.equals(other.flows);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.version, this.name, this.description, this.exportedAt, this.contexts, this.values, this.rules, this.flows);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> version = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<OffsetDateTime> exportedAt = Optional.empty();

    private Optional<List<Map<String, Object>>> contexts = Optional.empty();

    private Optional<List<Map<String, Object>>> values = Optional.empty();

    private Optional<List<Map<String, Object>>> rules = Optional.empty();

    private Optional<List<Map<String, Object>>> flows = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(ExportManifestResponseManifest other) {
      version(other.getVersion());
      name(other.getName());
      description(other.getDescription());
      exportedAt(other.getExportedAt());
      contexts(other.getContexts());
      values(other.getValues());
      rules(other.getRules());
      flows(other.getFlows());
      return this;
    }

    /**
     * <p>Manifest format version.</p>
     */
    @JsonSetter(
        value = "version",
        nulls = Nulls.SKIP
    )
    public Builder version(Optional<String> version) {
      this.version = version;
      return this;
    }

    public Builder version(String version) {
      this.version = Optional.ofNullable(version);
      return this;
    }

    /**
     * <p>Manifest name.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>Manifest description.</p>
     */
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    @JsonSetter(
        value = "exported_at",
        nulls = Nulls.SKIP
    )
    public Builder exportedAt(Optional<OffsetDateTime> exportedAt) {
      this.exportedAt = exportedAt;
      return this;
    }

    public Builder exportedAt(OffsetDateTime exportedAt) {
      this.exportedAt = Optional.ofNullable(exportedAt);
      return this;
    }

    /**
     * <p>Exported contexts.</p>
     */
    @JsonSetter(
        value = "contexts",
        nulls = Nulls.SKIP
    )
    public Builder contexts(Optional<List<Map<String, Object>>> contexts) {
      this.contexts = contexts;
      return this;
    }

    public Builder contexts(List<Map<String, Object>> contexts) {
      this.contexts = Optional.ofNullable(contexts);
      return this;
    }

    /**
     * <p>Exported dynamic values.</p>
     */
    @JsonSetter(
        value = "values",
        nulls = Nulls.SKIP
    )
    public Builder values(Optional<List<Map<String, Object>>> values) {
      this.values = values;
      return this;
    }

    public Builder values(List<Map<String, Object>> values) {
      this.values = Optional.ofNullable(values);
      return this;
    }

    /**
     * <p>Exported rules.</p>
     */
    @JsonSetter(
        value = "rules",
        nulls = Nulls.SKIP
    )
    public Builder rules(Optional<List<Map<String, Object>>> rules) {
      this.rules = rules;
      return this;
    }

    public Builder rules(List<Map<String, Object>> rules) {
      this.rules = Optional.ofNullable(rules);
      return this;
    }

    /**
     * <p>Exported flows.</p>
     */
    @JsonSetter(
        value = "flows",
        nulls = Nulls.SKIP
    )
    public Builder flows(Optional<List<Map<String, Object>>> flows) {
      this.flows = flows;
      return this;
    }

    public Builder flows(List<Map<String, Object>> flows) {
      this.flows = Optional.ofNullable(flows);
      return this;
    }

    public ExportManifestResponseManifest build() {
      return new ExportManifestResponseManifest(version, name, description, exportedAt, contexts, values, rules, flows, additionalProperties);
    }
  }
}
