/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = FlowExecutionError.Builder.class
)
public final class FlowExecutionError {
  private final Optional<String> error;

  private final Optional<String> node;

  private final Optional<Map<String, Object>> details;

  private final Map<String, Object> additionalProperties;

  private FlowExecutionError(Optional<String> error, Optional<String> node,
      Optional<Map<String, Object>> details, Map<String, Object> additionalProperties) {
    this.error = error;
    this.node = node;
    this.details = details;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Error message describing what went wrong during flow execution
   */
  @JsonProperty("error")
  public Optional<String> getError() {
    return error;
  }

  /**
   * @return Identifier of the node where the error occurred (if applicable)
   */
  @JsonProperty("node")
  public Optional<String> getNode() {
    return node;
  }

  /**
   * @return Additional error details
   */
  @JsonProperty("details")
  public Optional<Map<String, Object>> getDetails() {
    return details;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof FlowExecutionError && equalTo((FlowExecutionError) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(FlowExecutionError other) {
    return error.equals(other.error) && node.equals(other.node) && details.equals(other.details);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.error, this.node, this.details);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> error = Optional.empty();

    private Optional<String> node = Optional.empty();

    private Optional<Map<String, Object>> details = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(FlowExecutionError other) {
      error(other.getError());
      node(other.getNode());
      details(other.getDetails());
      return this;
    }

    /**
     * <p>Error message describing what went wrong during flow execution</p>
     */
    @JsonSetter(
        value = "error",
        nulls = Nulls.SKIP
    )
    public Builder error(Optional<String> error) {
      this.error = error;
      return this;
    }

    public Builder error(String error) {
      this.error = Optional.ofNullable(error);
      return this;
    }

    /**
     * <p>Identifier of the node where the error occurred (if applicable)</p>
     */
    @JsonSetter(
        value = "node",
        nulls = Nulls.SKIP
    )
    public Builder node(Optional<String> node) {
      this.node = node;
      return this;
    }

    public Builder node(String node) {
      this.node = Optional.ofNullable(node);
      return this;
    }

    /**
     * <p>Additional error details</p>
     */
    @JsonSetter(
        value = "details",
        nulls = Nulls.SKIP
    )
    public Builder details(Optional<Map<String, Object>> details) {
      this.details = details;
      return this;
    }

    public Builder details(Map<String, Object> details) {
      this.details = Optional.ofNullable(details);
      return this;
    }

    public FlowExecutionError build() {
      return new FlowExecutionError(error, node, details, additionalProperties);
    }
  }
}
