/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = Folder.Builder.class
)
public final class Folder {
  private final Optional<String> id;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<OffsetDateTime> createdAt;

  private final Optional<OffsetDateTime> updatedAt;

  private final Optional<List<String>> userGroups;

  private final Map<String, Object> additionalProperties;

  private Folder(Optional<String> id, Optional<String> name, Optional<String> description,
      Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> updatedAt,
      Optional<List<String>> userGroups, Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.userGroups = userGroups;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Unique identifier for the folder.
   */
  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return Name of the folder.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Description of the folder.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return Timestamp of when the folder was created.
   */
  @JsonProperty("created_at")
  public Optional<OffsetDateTime> getCreatedAt() {
    return createdAt;
  }

  /**
   * @return Timestamp of when the folder was last updated.
   */
  @JsonProperty("updated_at")
  public Optional<OffsetDateTime> getUpdatedAt() {
    return updatedAt;
  }

  /**
   * @return User groups that can view this folder.
   */
  @JsonProperty("user_groups")
  public Optional<List<String>> getUserGroups() {
    return userGroups;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof Folder && equalTo((Folder) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(Folder other) {
    return id.equals(other.id) && name.equals(other.name) && description.equals(other.description) && createdAt.equals(other.createdAt) && updatedAt.equals(other.updatedAt) && userGroups.equals(other.userGroups);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.description, this.createdAt, this.updatedAt, this.userGroups);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<OffsetDateTime> createdAt = Optional.empty();

    private Optional<OffsetDateTime> updatedAt = Optional.empty();

    private Optional<List<String>> userGroups = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(Folder other) {
      id(other.getId());
      name(other.getName());
      description(other.getDescription());
      createdAt(other.getCreatedAt());
      updatedAt(other.getUpdatedAt());
      userGroups(other.getUserGroups());
      return this;
    }

    /**
     * <p>Unique identifier for the folder.</p>
     */
    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    /**
     * <p>Name of the folder.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>Description of the folder.</p>
     */
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>Timestamp of when the folder was created.</p>
     */
    @JsonSetter(
        value = "created_at",
        nulls = Nulls.SKIP
    )
    public Builder createdAt(Optional<OffsetDateTime> createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = Optional.ofNullable(createdAt);
      return this;
    }

    /**
     * <p>Timestamp of when the folder was last updated.</p>
     */
    @JsonSetter(
        value = "updated_at",
        nulls = Nulls.SKIP
    )
    public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    public Builder updatedAt(OffsetDateTime updatedAt) {
      this.updatedAt = Optional.ofNullable(updatedAt);
      return this;
    }

    /**
     * <p>User groups that can view this folder.</p>
     */
    @JsonSetter(
        value = "user_groups",
        nulls = Nulls.SKIP
    )
    public Builder userGroups(Optional<List<String>> userGroups) {
      this.userGroups = userGroups;
      return this;
    }

    public Builder userGroups(List<String> userGroups) {
      this.userGroups = Optional.ofNullable(userGroups);
      return this;
    }

    public Folder build() {
      return new Folder(id, name, description, createdAt, updatedAt, userGroups, additionalProperties);
    }
  }
}
