/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = SchemaField.Builder.class
)
public final class SchemaField {
  private final Optional<String> key;

  private final Optional<Boolean> show;

  private final Optional<String> name;

  private final Optional<String> description;

  private final Optional<SchemaFieldType> type;

  private final Optional<SchemaFieldDefaultValue> defaultValue;

  private final Optional<String> defaultComputedValue;

  private final Optional<String> transform;

  private final Map<String, Object> additionalProperties;

  private SchemaField(Optional<String> key, Optional<Boolean> show, Optional<String> name,
      Optional<String> description, Optional<SchemaFieldType> type,
      Optional<SchemaFieldDefaultValue> defaultValue, Optional<String> defaultComputedValue,
      Optional<String> transform, Map<String, Object> additionalProperties) {
    this.key = key;
    this.show = show;
    this.name = name;
    this.description = description;
    this.type = type;
    this.defaultValue = defaultValue;
    this.defaultComputedValue = defaultComputedValue;
    this.transform = transform;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The unique key for this field.
   */
  @JsonProperty("key")
  public Optional<String> getKey() {
    return key;
  }

  /**
   * @return Whether this field is visible in the UI.
   */
  @JsonProperty("show")
  public Optional<Boolean> getShow() {
    return show;
  }

  /**
   * @return Display name for this field.
   */
  @JsonProperty("name")
  public Optional<String> getName() {
    return name;
  }

  /**
   * @return Description of this field.
   */
  @JsonProperty("description")
  public Optional<String> getDescription() {
    return description;
  }

  /**
   * @return Data type of this field.
   */
  @JsonProperty("type")
  public Optional<SchemaFieldType> getType() {
    return type;
  }

  /**
   * @return Default value for this field.
   */
  @JsonIgnore
  public Optional<SchemaFieldDefaultValue> getDefaultValue() {
    if (defaultValue == null) {
      return Optional.empty();
    }
    return defaultValue;
  }

  /**
   * @return Computed default value for this field.
   */
  @JsonIgnore
  public Optional<String> getDefaultComputedValue() {
    if (defaultComputedValue == null) {
      return Optional.empty();
    }
    return defaultComputedValue;
  }

  /**
   * @return Transformation expression to apply to this field.
   */
  @JsonProperty("transform")
  public Optional<String> getTransform() {
    return transform;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("default_value")
  private Optional<SchemaFieldDefaultValue> _getDefaultValue() {
    return defaultValue;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("default_computed_value")
  private Optional<String> _getDefaultComputedValue() {
    return defaultComputedValue;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof SchemaField && equalTo((SchemaField) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(SchemaField other) {
    return key.equals(other.key) && show.equals(other.show) && name.equals(other.name) && description.equals(other.description) && type.equals(other.type) && defaultValue.equals(other.defaultValue) && defaultComputedValue.equals(other.defaultComputedValue) && transform.equals(other.transform);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.key, this.show, this.name, this.description, this.type, this.defaultValue, this.defaultComputedValue, this.transform);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> key = Optional.empty();

    private Optional<Boolean> show = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> description = Optional.empty();

    private Optional<SchemaFieldType> type = Optional.empty();

    private Optional<SchemaFieldDefaultValue> defaultValue = Optional.empty();

    private Optional<String> defaultComputedValue = Optional.empty();

    private Optional<String> transform = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(SchemaField other) {
      key(other.getKey());
      show(other.getShow());
      name(other.getName());
      description(other.getDescription());
      type(other.getType());
      defaultValue(other.getDefaultValue());
      defaultComputedValue(other.getDefaultComputedValue());
      transform(other.getTransform());
      return this;
    }

    /**
     * <p>The unique key for this field.</p>
     */
    @JsonSetter(
        value = "key",
        nulls = Nulls.SKIP
    )
    public Builder key(Optional<String> key) {
      this.key = key;
      return this;
    }

    public Builder key(String key) {
      this.key = Optional.ofNullable(key);
      return this;
    }

    /**
     * <p>Whether this field is visible in the UI.</p>
     */
    @JsonSetter(
        value = "show",
        nulls = Nulls.SKIP
    )
    public Builder show(Optional<Boolean> show) {
      this.show = show;
      return this;
    }

    public Builder show(Boolean show) {
      this.show = Optional.ofNullable(show);
      return this;
    }

    /**
     * <p>Display name for this field.</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    /**
     * <p>Description of this field.</p>
     */
    @JsonSetter(
        value = "description",
        nulls = Nulls.SKIP
    )
    public Builder description(Optional<String> description) {
      this.description = description;
      return this;
    }

    public Builder description(String description) {
      this.description = Optional.ofNullable(description);
      return this;
    }

    /**
     * <p>Data type of this field.</p>
     */
    @JsonSetter(
        value = "type",
        nulls = Nulls.SKIP
    )
    public Builder type(Optional<SchemaFieldType> type) {
      this.type = type;
      return this;
    }

    public Builder type(SchemaFieldType type) {
      this.type = Optional.ofNullable(type);
      return this;
    }

    /**
     * <p>Default value for this field.</p>
     */
    @JsonSetter(
        value = "default_value",
        nulls = Nulls.SKIP
    )
    public Builder defaultValue(Optional<SchemaFieldDefaultValue> defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }

    public Builder defaultValue(SchemaFieldDefaultValue defaultValue) {
      this.defaultValue = Optional.ofNullable(defaultValue);
      return this;
    }

    public Builder defaultValue(Nullable<SchemaFieldDefaultValue> defaultValue) {
      if (defaultValue.isNull()) {
        this.defaultValue = null;
      }
      else if (defaultValue.isEmpty()) {
        this.defaultValue = Optional.empty();
      }
      else {
        this.defaultValue = Optional.of(defaultValue.get());
      }
      return this;
    }

    /**
     * <p>Computed default value for this field.</p>
     */
    @JsonSetter(
        value = "default_computed_value",
        nulls = Nulls.SKIP
    )
    public Builder defaultComputedValue(Optional<String> defaultComputedValue) {
      this.defaultComputedValue = defaultComputedValue;
      return this;
    }

    public Builder defaultComputedValue(String defaultComputedValue) {
      this.defaultComputedValue = Optional.ofNullable(defaultComputedValue);
      return this;
    }

    public Builder defaultComputedValue(Nullable<String> defaultComputedValue) {
      if (defaultComputedValue.isNull()) {
        this.defaultComputedValue = null;
      }
      else if (defaultComputedValue.isEmpty()) {
        this.defaultComputedValue = Optional.empty();
      }
      else {
        this.defaultComputedValue = Optional.of(defaultComputedValue.get());
      }
      return this;
    }

    /**
     * <p>Transformation expression to apply to this field.</p>
     */
    @JsonSetter(
        value = "transform",
        nulls = Nulls.SKIP
    )
    public Builder transform(Optional<String> transform) {
      this.transform = transform;
      return this;
    }

    public Builder transform(String transform) {
      this.transform = Optional.ofNullable(transform);
      return this;
    }

    public SchemaField build() {
      return new SchemaField(key, show, name, description, type, defaultValue, defaultComputedValue, transform, additionalProperties);
    }
  }
}
