/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = Test.Builder.class
)
public final class Test {
  private final String id;

  private final String name;

  private final Map<String, Object> request;

  private final Map<String, Object> response;

  private final boolean critical;

  private final Optional<Boolean> error;

  private final Optional<Boolean> success;

  private final Optional<TestTestState> testState;

  private final Optional<OffsetDateTime> lastExecuted;

  private final Map<String, Object> additionalProperties;

  private Test(String id, String name, Map<String, Object> request, Map<String, Object> response,
      boolean critical, Optional<Boolean> error, Optional<Boolean> success,
      Optional<TestTestState> testState, Optional<OffsetDateTime> lastExecuted,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.name = name;
    this.request = request;
    this.response = response;
    this.critical = critical;
    this.error = error;
    this.success = success;
    this.testState = testState;
    this.lastExecuted = lastExecuted;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Unique identifier for the test.
   */
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  /**
   * @return The name of the test.
   */
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  /**
   * @return The request object for the test.
   */
  @JsonProperty("request")
  public Map<String, Object> getRequest() {
    return request;
  }

  /**
   * @return The expected response object for the test.
   */
  @JsonProperty("response")
  public Map<String, Object> getResponse() {
    return response;
  }

  /**
   * @return Indicates whether the test is critical.
   */
  @JsonProperty("critical")
  public boolean getCritical() {
    return critical;
  }

  /**
   * @return Indicates if the test resulted in an error. Null if test has not been executed.
   */
  @JsonIgnore
  public Optional<Boolean> getError() {
    if (error == null) {
      return Optional.empty();
    }
    return error;
  }

  /**
   * @return Indicates if the test was successful. Null if test has not been executed.
   */
  @JsonIgnore
  public Optional<Boolean> getSuccess() {
    if (success == null) {
      return Optional.empty();
    }
    return success;
  }

  /**
   * @return The state of the test after execution.
   */
  @JsonIgnore
  public Optional<TestTestState> getTestState() {
    if (testState == null) {
      return Optional.empty();
    }
    return testState;
  }

  /**
   * @return The timestamp when the test was last executed.
   */
  @JsonIgnore
  public Optional<OffsetDateTime> getLastExecuted() {
    if (lastExecuted == null) {
      return Optional.empty();
    }
    return lastExecuted;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("error")
  private Optional<Boolean> _getError() {
    return error;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("success")
  private Optional<Boolean> _getSuccess() {
    return success;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("test_state")
  private Optional<TestTestState> _getTestState() {
    return testState;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("last_executed")
  private Optional<OffsetDateTime> _getLastExecuted() {
    return lastExecuted;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof Test && equalTo((Test) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(Test other) {
    return id.equals(other.id) && name.equals(other.name) && request.equals(other.request) && response.equals(other.response) && critical == other.critical && error.equals(other.error) && success.equals(other.success) && testState.equals(other.testState) && lastExecuted.equals(other.lastExecuted);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.name, this.request, this.response, this.critical, this.error, this.success, this.testState, this.lastExecuted);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static IdStage builder() {
    return new Builder();
  }

  public interface IdStage {
    /**
     * <p>Unique identifier for the test.</p>
     */
    NameStage id(@NotNull String id);

    Builder from(Test other);
  }

  public interface NameStage {
    /**
     * <p>The name of the test.</p>
     */
    CriticalStage name(@NotNull String name);
  }

  public interface CriticalStage {
    /**
     * <p>Indicates whether the test is critical.</p>
     */
    _FinalStage critical(boolean critical);
  }

  public interface _FinalStage {
    Test build();

    /**
     * <p>The request object for the test.</p>
     */
    _FinalStage request(Map<String, Object> request);

    _FinalStage putAllRequest(Map<String, Object> request);

    _FinalStage request(String key, Object value);

    /**
     * <p>The expected response object for the test.</p>
     */
    _FinalStage response(Map<String, Object> response);

    _FinalStage putAllResponse(Map<String, Object> response);

    _FinalStage response(String key, Object value);

    /**
     * <p>Indicates if the test resulted in an error. Null if test has not been executed.</p>
     */
    _FinalStage error(Optional<Boolean> error);

    _FinalStage error(Boolean error);

    _FinalStage error(Nullable<Boolean> error);

    /**
     * <p>Indicates if the test was successful. Null if test has not been executed.</p>
     */
    _FinalStage success(Optional<Boolean> success);

    _FinalStage success(Boolean success);

    _FinalStage success(Nullable<Boolean> success);

    /**
     * <p>The state of the test after execution.</p>
     */
    _FinalStage testState(Optional<TestTestState> testState);

    _FinalStage testState(TestTestState testState);

    _FinalStage testState(Nullable<TestTestState> testState);

    /**
     * <p>The timestamp when the test was last executed.</p>
     */
    _FinalStage lastExecuted(Optional<OffsetDateTime> lastExecuted);

    _FinalStage lastExecuted(OffsetDateTime lastExecuted);

    _FinalStage lastExecuted(Nullable<OffsetDateTime> lastExecuted);
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder implements IdStage, NameStage, CriticalStage, _FinalStage {
    private String id;

    private String name;

    private boolean critical;

    private Optional<OffsetDateTime> lastExecuted = Optional.empty();

    private Optional<TestTestState> testState = Optional.empty();

    private Optional<Boolean> success = Optional.empty();

    private Optional<Boolean> error = Optional.empty();

    private Map<String, Object> response = new LinkedHashMap<>();

    private Map<String, Object> request = new LinkedHashMap<>();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    @java.lang.Override
    public Builder from(Test other) {
      id(other.getId());
      name(other.getName());
      request(other.getRequest());
      response(other.getResponse());
      critical(other.getCritical());
      error(other.getError());
      success(other.getSuccess());
      testState(other.getTestState());
      lastExecuted(other.getLastExecuted());
      return this;
    }

    /**
     * <p>Unique identifier for the test.</p>
     * <p>Unique identifier for the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("id")
    public NameStage id(@NotNull String id) {
      this.id = Objects.requireNonNull(id, "id must not be null");
      return this;
    }

    /**
     * <p>The name of the test.</p>
     * <p>The name of the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("name")
    public CriticalStage name(@NotNull String name) {
      this.name = Objects.requireNonNull(name, "name must not be null");
      return this;
    }

    /**
     * <p>Indicates whether the test is critical.</p>
     * <p>Indicates whether the test is critical.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    @JsonSetter("critical")
    public _FinalStage critical(boolean critical) {
      this.critical = critical;
      return this;
    }

    /**
     * <p>The timestamp when the test was last executed.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage lastExecuted(Nullable<OffsetDateTime> lastExecuted) {
      if (lastExecuted.isNull()) {
        this.lastExecuted = null;
      }
      else if (lastExecuted.isEmpty()) {
        this.lastExecuted = Optional.empty();
      }
      else {
        this.lastExecuted = Optional.of(lastExecuted.get());
      }
      return this;
    }

    /**
     * <p>The timestamp when the test was last executed.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage lastExecuted(OffsetDateTime lastExecuted) {
      this.lastExecuted = Optional.ofNullable(lastExecuted);
      return this;
    }

    /**
     * <p>The timestamp when the test was last executed.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "last_executed",
        nulls = Nulls.SKIP
    )
    public _FinalStage lastExecuted(Optional<OffsetDateTime> lastExecuted) {
      this.lastExecuted = lastExecuted;
      return this;
    }

    /**
     * <p>The state of the test after execution.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage testState(Nullable<TestTestState> testState) {
      if (testState.isNull()) {
        this.testState = null;
      }
      else if (testState.isEmpty()) {
        this.testState = Optional.empty();
      }
      else {
        this.testState = Optional.of(testState.get());
      }
      return this;
    }

    /**
     * <p>The state of the test after execution.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage testState(TestTestState testState) {
      this.testState = Optional.ofNullable(testState);
      return this;
    }

    /**
     * <p>The state of the test after execution.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "test_state",
        nulls = Nulls.SKIP
    )
    public _FinalStage testState(Optional<TestTestState> testState) {
      this.testState = testState;
      return this;
    }

    /**
     * <p>Indicates if the test was successful. Null if test has not been executed.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage success(Nullable<Boolean> success) {
      if (success.isNull()) {
        this.success = null;
      }
      else if (success.isEmpty()) {
        this.success = Optional.empty();
      }
      else {
        this.success = Optional.of(success.get());
      }
      return this;
    }

    /**
     * <p>Indicates if the test was successful. Null if test has not been executed.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage success(Boolean success) {
      this.success = Optional.ofNullable(success);
      return this;
    }

    /**
     * <p>Indicates if the test was successful. Null if test has not been executed.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "success",
        nulls = Nulls.SKIP
    )
    public _FinalStage success(Optional<Boolean> success) {
      this.success = success;
      return this;
    }

    /**
     * <p>Indicates if the test resulted in an error. Null if test has not been executed.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage error(Nullable<Boolean> error) {
      if (error.isNull()) {
        this.error = null;
      }
      else if (error.isEmpty()) {
        this.error = Optional.empty();
      }
      else {
        this.error = Optional.of(error.get());
      }
      return this;
    }

    /**
     * <p>Indicates if the test resulted in an error. Null if test has not been executed.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage error(Boolean error) {
      this.error = Optional.ofNullable(error);
      return this;
    }

    /**
     * <p>Indicates if the test resulted in an error. Null if test has not been executed.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "error",
        nulls = Nulls.SKIP
    )
    public _FinalStage error(Optional<Boolean> error) {
      this.error = error;
      return this;
    }

    /**
     * <p>The expected response object for the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage response(String key, Object value) {
      this.response.put(key, value);
      return this;
    }

    /**
     * <p>The expected response object for the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage putAllResponse(Map<String, Object> response) {
      if (response != null) {
        this.response.putAll(response);
      }
      return this;
    }

    /**
     * <p>The expected response object for the test.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "response",
        nulls = Nulls.SKIP
    )
    public _FinalStage response(Map<String, Object> response) {
      this.response.clear();
      if (response != null) {
        this.response.putAll(response);
      }
      return this;
    }

    /**
     * <p>The request object for the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage request(String key, Object value) {
      this.request.put(key, value);
      return this;
    }

    /**
     * <p>The request object for the test.</p>
     * @return Reference to {@code this} so that method calls can be chained together.
     */
    @java.lang.Override
    public _FinalStage putAllRequest(Map<String, Object> request) {
      if (request != null) {
        this.request.putAll(request);
      }
      return this;
    }

    /**
     * <p>The request object for the test.</p>
     */
    @java.lang.Override
    @JsonSetter(
        value = "request",
        nulls = Nulls.SKIP
    )
    public _FinalStage request(Map<String, Object> request) {
      this.request.clear();
      if (request != null) {
        this.request.putAll(request);
      }
      return this;
    }

    @java.lang.Override
    public Test build() {
      return new Test(id, name, request, response, critical, error, success, testState, lastExecuted, additionalProperties);
    }
  }
}
