/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = UsageStatistics.Builder.class
)
public final class UsageStatistics {
  private final Optional<String> plan;

  private final Optional<String> monthlyPeriodStart;

  private final Optional<String> monthlyPeriodEnd;

  private final Optional<Double> monthlyExecutionsUsage;

  private final Optional<Double> monthlyExecutionsLimit;

  private final Optional<Double> monthlyExecutionsRemaining;

  private final Optional<Boolean> unlimitedPlan;

  private final Optional<Double> daysRemainingInPeriod;

  private final Optional<Double> dailyAverageUsage;

  private final Map<String, Object> additionalProperties;

  private UsageStatistics(Optional<String> plan, Optional<String> monthlyPeriodStart,
      Optional<String> monthlyPeriodEnd, Optional<Double> monthlyExecutionsUsage,
      Optional<Double> monthlyExecutionsLimit, Optional<Double> monthlyExecutionsRemaining,
      Optional<Boolean> unlimitedPlan, Optional<Double> daysRemainingInPeriod,
      Optional<Double> dailyAverageUsage, Map<String, Object> additionalProperties) {
    this.plan = plan;
    this.monthlyPeriodStart = monthlyPeriodStart;
    this.monthlyPeriodEnd = monthlyPeriodEnd;
    this.monthlyExecutionsUsage = monthlyExecutionsUsage;
    this.monthlyExecutionsLimit = monthlyExecutionsLimit;
    this.monthlyExecutionsRemaining = monthlyExecutionsRemaining;
    this.unlimitedPlan = unlimitedPlan;
    this.daysRemainingInPeriod = daysRemainingInPeriod;
    this.dailyAverageUsage = dailyAverageUsage;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The current plan of the organization.
   */
  @JsonProperty("plan")
  public Optional<String> getPlan() {
    return plan;
  }

  /**
   * @return The start date of the current monthly period (MM-DD-YYYY).
   */
  @JsonProperty("monthly_period_start")
  public Optional<String> getMonthlyPeriodStart() {
    return monthlyPeriodStart;
  }

  /**
   * @return The end date of the current monthly period (MM-DD-YYYY).
   */
  @JsonProperty("monthly_period_end")
  public Optional<String> getMonthlyPeriodEnd() {
    return monthlyPeriodEnd;
  }

  /**
   * @return The number of rule executions used this month.
   */
  @JsonProperty("monthly_executions_usage")
  public Optional<Double> getMonthlyExecutionsUsage() {
    return monthlyExecutionsUsage;
  }

  /**
   * @return The total number of rule executions allowed this month. -1 indicates unlimited.
   */
  @JsonProperty("monthly_executions_limit")
  public Optional<Double> getMonthlyExecutionsLimit() {
    return monthlyExecutionsLimit;
  }

  /**
   * @return The number of rule executions remaining this month. -1 indicates unlimited.
   */
  @JsonProperty("monthly_executions_remaining")
  public Optional<Double> getMonthlyExecutionsRemaining() {
    return monthlyExecutionsRemaining;
  }

  /**
   * @return Whether the plan has unlimited executions (true when monthly_executions_limit is -1).
   */
  @JsonProperty("unlimited_plan")
  public Optional<Boolean> getUnlimitedPlan() {
    return unlimitedPlan;
  }

  /**
   * @return Number of days remaining in the current billing period.
   */
  @JsonProperty("days_remaining_in_period")
  public Optional<Double> getDaysRemainingInPeriod() {
    return daysRemainingInPeriod;
  }

  /**
   * @return Average number of executions per day in the current period.
   */
  @JsonProperty("daily_average_usage")
  public Optional<Double> getDailyAverageUsage() {
    return dailyAverageUsage;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof UsageStatistics && equalTo((UsageStatistics) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(UsageStatistics other) {
    return plan.equals(other.plan) && monthlyPeriodStart.equals(other.monthlyPeriodStart) && monthlyPeriodEnd.equals(other.monthlyPeriodEnd) && monthlyExecutionsUsage.equals(other.monthlyExecutionsUsage) && monthlyExecutionsLimit.equals(other.monthlyExecutionsLimit) && monthlyExecutionsRemaining.equals(other.monthlyExecutionsRemaining) && unlimitedPlan.equals(other.unlimitedPlan) && daysRemainingInPeriod.equals(other.daysRemainingInPeriod) && dailyAverageUsage.equals(other.dailyAverageUsage);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.plan, this.monthlyPeriodStart, this.monthlyPeriodEnd, this.monthlyExecutionsUsage, this.monthlyExecutionsLimit, this.monthlyExecutionsRemaining, this.unlimitedPlan, this.daysRemainingInPeriod, this.dailyAverageUsage);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> plan = Optional.empty();

    private Optional<String> monthlyPeriodStart = Optional.empty();

    private Optional<String> monthlyPeriodEnd = Optional.empty();

    private Optional<Double> monthlyExecutionsUsage = Optional.empty();

    private Optional<Double> monthlyExecutionsLimit = Optional.empty();

    private Optional<Double> monthlyExecutionsRemaining = Optional.empty();

    private Optional<Boolean> unlimitedPlan = Optional.empty();

    private Optional<Double> daysRemainingInPeriod = Optional.empty();

    private Optional<Double> dailyAverageUsage = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(UsageStatistics other) {
      plan(other.getPlan());
      monthlyPeriodStart(other.getMonthlyPeriodStart());
      monthlyPeriodEnd(other.getMonthlyPeriodEnd());
      monthlyExecutionsUsage(other.getMonthlyExecutionsUsage());
      monthlyExecutionsLimit(other.getMonthlyExecutionsLimit());
      monthlyExecutionsRemaining(other.getMonthlyExecutionsRemaining());
      unlimitedPlan(other.getUnlimitedPlan());
      daysRemainingInPeriod(other.getDaysRemainingInPeriod());
      dailyAverageUsage(other.getDailyAverageUsage());
      return this;
    }

    /**
     * <p>The current plan of the organization.</p>
     */
    @JsonSetter(
        value = "plan",
        nulls = Nulls.SKIP
    )
    public Builder plan(Optional<String> plan) {
      this.plan = plan;
      return this;
    }

    public Builder plan(String plan) {
      this.plan = Optional.ofNullable(plan);
      return this;
    }

    /**
     * <p>The start date of the current monthly period (MM-DD-YYYY).</p>
     */
    @JsonSetter(
        value = "monthly_period_start",
        nulls = Nulls.SKIP
    )
    public Builder monthlyPeriodStart(Optional<String> monthlyPeriodStart) {
      this.monthlyPeriodStart = monthlyPeriodStart;
      return this;
    }

    public Builder monthlyPeriodStart(String monthlyPeriodStart) {
      this.monthlyPeriodStart = Optional.ofNullable(monthlyPeriodStart);
      return this;
    }

    /**
     * <p>The end date of the current monthly period (MM-DD-YYYY).</p>
     */
    @JsonSetter(
        value = "monthly_period_end",
        nulls = Nulls.SKIP
    )
    public Builder monthlyPeriodEnd(Optional<String> monthlyPeriodEnd) {
      this.monthlyPeriodEnd = monthlyPeriodEnd;
      return this;
    }

    public Builder monthlyPeriodEnd(String monthlyPeriodEnd) {
      this.monthlyPeriodEnd = Optional.ofNullable(monthlyPeriodEnd);
      return this;
    }

    /**
     * <p>The number of rule executions used this month.</p>
     */
    @JsonSetter(
        value = "monthly_executions_usage",
        nulls = Nulls.SKIP
    )
    public Builder monthlyExecutionsUsage(Optional<Double> monthlyExecutionsUsage) {
      this.monthlyExecutionsUsage = monthlyExecutionsUsage;
      return this;
    }

    public Builder monthlyExecutionsUsage(Double monthlyExecutionsUsage) {
      this.monthlyExecutionsUsage = Optional.ofNullable(monthlyExecutionsUsage);
      return this;
    }

    /**
     * <p>The total number of rule executions allowed this month. -1 indicates unlimited.</p>
     */
    @JsonSetter(
        value = "monthly_executions_limit",
        nulls = Nulls.SKIP
    )
    public Builder monthlyExecutionsLimit(Optional<Double> monthlyExecutionsLimit) {
      this.monthlyExecutionsLimit = monthlyExecutionsLimit;
      return this;
    }

    public Builder monthlyExecutionsLimit(Double monthlyExecutionsLimit) {
      this.monthlyExecutionsLimit = Optional.ofNullable(monthlyExecutionsLimit);
      return this;
    }

    /**
     * <p>The number of rule executions remaining this month. -1 indicates unlimited.</p>
     */
    @JsonSetter(
        value = "monthly_executions_remaining",
        nulls = Nulls.SKIP
    )
    public Builder monthlyExecutionsRemaining(Optional<Double> monthlyExecutionsRemaining) {
      this.monthlyExecutionsRemaining = monthlyExecutionsRemaining;
      return this;
    }

    public Builder monthlyExecutionsRemaining(Double monthlyExecutionsRemaining) {
      this.monthlyExecutionsRemaining = Optional.ofNullable(monthlyExecutionsRemaining);
      return this;
    }

    /**
     * <p>Whether the plan has unlimited executions (true when monthly_executions_limit is -1).</p>
     */
    @JsonSetter(
        value = "unlimited_plan",
        nulls = Nulls.SKIP
    )
    public Builder unlimitedPlan(Optional<Boolean> unlimitedPlan) {
      this.unlimitedPlan = unlimitedPlan;
      return this;
    }

    public Builder unlimitedPlan(Boolean unlimitedPlan) {
      this.unlimitedPlan = Optional.ofNullable(unlimitedPlan);
      return this;
    }

    /**
     * <p>Number of days remaining in the current billing period.</p>
     */
    @JsonSetter(
        value = "days_remaining_in_period",
        nulls = Nulls.SKIP
    )
    public Builder daysRemainingInPeriod(Optional<Double> daysRemainingInPeriod) {
      this.daysRemainingInPeriod = daysRemainingInPeriod;
      return this;
    }

    public Builder daysRemainingInPeriod(Double daysRemainingInPeriod) {
      this.daysRemainingInPeriod = Optional.ofNullable(daysRemainingInPeriod);
      return this;
    }

    /**
     * <p>Average number of executions per day in the current period.</p>
     */
    @JsonSetter(
        value = "daily_average_usage",
        nulls = Nulls.SKIP
    )
    public Builder dailyAverageUsage(Optional<Double> dailyAverageUsage) {
      this.dailyAverageUsage = dailyAverageUsage;
      return this;
    }

    public Builder dailyAverageUsage(Double dailyAverageUsage) {
      this.dailyAverageUsage = Optional.ofNullable(dailyAverageUsage);
      return this;
    }

    public UsageStatistics build() {
      return new UsageStatistics(plan, monthlyPeriodStart, monthlyPeriodEnd, monthlyExecutionsUsage, monthlyExecutionsLimit, monthlyExecutionsRemaining, unlimitedPlan, daysRemainingInPeriod, dailyAverageUsage, additionalProperties);
    }
  }
}
