/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(
    builder = UserDetail.Builder.class
)
public final class UserDetail {
  private final Optional<String> id;

  private final Optional<String> email;

  private final Optional<String> name;

  private final Optional<String> apiKey;

  private final Optional<String> role;

  private final Optional<List<String>> userGroups;

  private final Optional<OffsetDateTime> joinedAt;

  private final Map<String, Object> additionalProperties;

  private UserDetail(Optional<String> id, Optional<String> email, Optional<String> name,
      Optional<String> apiKey, Optional<String> role, Optional<List<String>> userGroups,
      Optional<OffsetDateTime> joinedAt, Map<String, Object> additionalProperties) {
    this.id = id;
    this.email = email;
    this.name = name;
    this.apiKey = apiKey;
    this.role = role;
    this.userGroups = userGroups;
    this.joinedAt = joinedAt;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return Unique identifier for the user.
   */
  @JsonProperty("id")
  public Optional<String> getId() {
    return id;
  }

  /**
   * @return Email address of the user.
   */
  @JsonProperty("email")
  public Optional<String> getEmail() {
    return email;
  }

  /**
   * @return Display name of the user (if set).
   */
  @JsonIgnore
  public Optional<String> getName() {
    if (name == null) {
      return Optional.empty();
    }
    return name;
  }

  /**
   * @return API key assigned to the user.
   */
  @JsonIgnore
  public Optional<String> getApiKey() {
    if (apiKey == null) {
      return Optional.empty();
    }
    return apiKey;
  }

  /**
   * @return Role assigned to the user (e.g., 'administrator', 'developer', 'editor', or custom role ID).
   */
  @JsonProperty("role")
  public Optional<String> getRole() {
    return role;
  }

  /**
   * @return List of user group names the user belongs to.
   */
  @JsonProperty("user_groups")
  public Optional<List<String>> getUserGroups() {
    return userGroups;
  }

  /**
   * @return Date and time when the user joined the organization.
   */
  @JsonIgnore
  public Optional<OffsetDateTime> getJoinedAt() {
    if (joinedAt == null) {
      return Optional.empty();
    }
    return joinedAt;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("name")
  private Optional<String> _getName() {
    return name;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("api_key")
  private Optional<String> _getApiKey() {
    return apiKey;
  }

  @JsonInclude(
      value = JsonInclude.Include.CUSTOM,
      valueFilter = NullableNonemptyFilter.class
  )
  @JsonProperty("joined_at")
  private Optional<OffsetDateTime> _getJoinedAt() {
    return joinedAt;
  }

  @java.lang.Override
  public boolean equals(Object other) {
    if (this == other) return true;
    return other instanceof UserDetail && equalTo((UserDetail) other);
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  private boolean equalTo(UserDetail other) {
    return id.equals(other.id) && email.equals(other.email) && name.equals(other.name) && apiKey.equals(other.apiKey) && role.equals(other.role) && userGroups.equals(other.userGroups) && joinedAt.equals(other.joinedAt);
  }

  @java.lang.Override
  public int hashCode() {
    return Objects.hash(this.id, this.email, this.name, this.apiKey, this.role, this.userGroups, this.joinedAt);
  }

  @java.lang.Override
  public String toString() {
    return ObjectMappers.stringify(this);
  }

  public static Builder builder() {
    return new Builder();
  }

  @JsonIgnoreProperties(
      ignoreUnknown = true
  )
  public static final class Builder {
    private Optional<String> id = Optional.empty();

    private Optional<String> email = Optional.empty();

    private Optional<String> name = Optional.empty();

    private Optional<String> apiKey = Optional.empty();

    private Optional<String> role = Optional.empty();

    private Optional<List<String>> userGroups = Optional.empty();

    private Optional<OffsetDateTime> joinedAt = Optional.empty();

    @JsonAnySetter
    private Map<String, Object> additionalProperties = new HashMap<>();

    private Builder() {
    }

    public Builder from(UserDetail other) {
      id(other.getId());
      email(other.getEmail());
      name(other.getName());
      apiKey(other.getApiKey());
      role(other.getRole());
      userGroups(other.getUserGroups());
      joinedAt(other.getJoinedAt());
      return this;
    }

    /**
     * <p>Unique identifier for the user.</p>
     */
    @JsonSetter(
        value = "id",
        nulls = Nulls.SKIP
    )
    public Builder id(Optional<String> id) {
      this.id = id;
      return this;
    }

    public Builder id(String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }

    /**
     * <p>Email address of the user.</p>
     */
    @JsonSetter(
        value = "email",
        nulls = Nulls.SKIP
    )
    public Builder email(Optional<String> email) {
      this.email = email;
      return this;
    }

    public Builder email(String email) {
      this.email = Optional.ofNullable(email);
      return this;
    }

    /**
     * <p>Display name of the user (if set).</p>
     */
    @JsonSetter(
        value = "name",
        nulls = Nulls.SKIP
    )
    public Builder name(Optional<String> name) {
      this.name = name;
      return this;
    }

    public Builder name(String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }

    public Builder name(Nullable<String> name) {
      if (name.isNull()) {
        this.name = null;
      }
      else if (name.isEmpty()) {
        this.name = Optional.empty();
      }
      else {
        this.name = Optional.of(name.get());
      }
      return this;
    }

    /**
     * <p>API key assigned to the user.</p>
     */
    @JsonSetter(
        value = "api_key",
        nulls = Nulls.SKIP
    )
    public Builder apiKey(Optional<String> apiKey) {
      this.apiKey = apiKey;
      return this;
    }

    public Builder apiKey(String apiKey) {
      this.apiKey = Optional.ofNullable(apiKey);
      return this;
    }

    public Builder apiKey(Nullable<String> apiKey) {
      if (apiKey.isNull()) {
        this.apiKey = null;
      }
      else if (apiKey.isEmpty()) {
        this.apiKey = Optional.empty();
      }
      else {
        this.apiKey = Optional.of(apiKey.get());
      }
      return this;
    }

    /**
     * <p>Role assigned to the user (e.g., 'administrator', 'developer', 'editor', or custom role ID).</p>
     */
    @JsonSetter(
        value = "role",
        nulls = Nulls.SKIP
    )
    public Builder role(Optional<String> role) {
      this.role = role;
      return this;
    }

    public Builder role(String role) {
      this.role = Optional.ofNullable(role);
      return this;
    }

    /**
     * <p>List of user group names the user belongs to.</p>
     */
    @JsonSetter(
        value = "user_groups",
        nulls = Nulls.SKIP
    )
    public Builder userGroups(Optional<List<String>> userGroups) {
      this.userGroups = userGroups;
      return this;
    }

    public Builder userGroups(List<String> userGroups) {
      this.userGroups = Optional.ofNullable(userGroups);
      return this;
    }

    /**
     * <p>Date and time when the user joined the organization.</p>
     */
    @JsonSetter(
        value = "joined_at",
        nulls = Nulls.SKIP
    )
    public Builder joinedAt(Optional<OffsetDateTime> joinedAt) {
      this.joinedAt = joinedAt;
      return this;
    }

    public Builder joinedAt(OffsetDateTime joinedAt) {
      this.joinedAt = Optional.ofNullable(joinedAt);
      return this;
    }

    public Builder joinedAt(Nullable<OffsetDateTime> joinedAt) {
      if (joinedAt.isNull()) {
        this.joinedAt = null;
      }
      else if (joinedAt.isEmpty()) {
        this.joinedAt = Optional.empty();
      }
      else {
        this.joinedAt = Optional.of(joinedAt.get());
      }
      return this;
    }

    public UserDetail build() {
      return new UserDetail(id, email, name, apiKey, role, userGroups, joinedAt, additionalProperties);
    }
  }
}
