/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.assets.RawAssetsClient;
import com.rulebricks.resources.assets.flows.FlowsClient;
import com.rulebricks.resources.assets.folders.FoldersClient;
import com.rulebricks.resources.assets.requests.ExportManifestRequest;
import com.rulebricks.resources.assets.requests.ImportManifestRequest;
import com.rulebricks.resources.assets.rules.RulesClient;
import com.rulebricks.resources.assets.types.ExportRbmAssetsResponse;
import com.rulebricks.types.ImportManifestResponse;
import com.rulebricks.types.UsageStatistics;
import java.util.function.Supplier;

public class AssetsClient {
    protected final ClientOptions clientOptions;
    private final RawAssetsClient rawClient;
    protected final Supplier<RulesClient> rulesClient;
    protected final Supplier<FlowsClient> flowsClient;
    protected final Supplier<FoldersClient> foldersClient;

    public AssetsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawAssetsClient(clientOptions);
        this.rulesClient = Suppliers.memoize(() -> new RulesClient(clientOptions));
        this.flowsClient = Suppliers.memoize(() -> new FlowsClient(clientOptions));
        this.foldersClient = Suppliers.memoize(() -> new FoldersClient(clientOptions));
    }

    public RawAssetsClient withRawResponse() {
        return this.rawClient;
    }

    public UsageStatistics getUsage() {
        return this.rawClient.getUsage().body();
    }

    public UsageStatistics getUsage(RequestOptions requestOptions) {
        return this.rawClient.getUsage(requestOptions).body();
    }

    public ImportManifestResponse importRbm(ImportManifestRequest request) {
        return this.rawClient.importRbm(request).body();
    }

    public ImportManifestResponse importRbm(ImportManifestRequest request, RequestOptions requestOptions) {
        return this.rawClient.importRbm(request, requestOptions).body();
    }

    public ExportRbmAssetsResponse exportRbm(ExportManifestRequest request) {
        return this.rawClient.exportRbm(request).body();
    }

    public ExportRbmAssetsResponse exportRbm(ExportManifestRequest request, RequestOptions requestOptions) {
        return this.rawClient.exportRbm(request, requestOptions).body();
    }

    public RulesClient rules() {
        return this.rulesClient.get();
    }

    public FlowsClient flows() {
        return this.flowsClient.get();
    }

    public FoldersClient folders() {
        return this.foldersClient.get();
    }
}

