/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.assets.types.ExportManifestRequestRootType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ExportManifestRequest {
    private final ExportManifestRequestRootType rootType;
    private final List<String> rootIds;
    private final Optional<Boolean> includeDownstream;
    private final Optional<String> manifestName;
    private final Optional<String> manifestDescription;
    private final Optional<Boolean> previewOnly;
    private final Map<String, Object> additionalProperties;

    private ExportManifestRequest(ExportManifestRequestRootType rootType, List<String> rootIds, Optional<Boolean> includeDownstream, Optional<String> manifestName, Optional<String> manifestDescription, Optional<Boolean> previewOnly, Map<String, Object> additionalProperties) {
        this.rootType = rootType;
        this.rootIds = rootIds;
        this.includeDownstream = includeDownstream;
        this.manifestName = manifestName;
        this.manifestDescription = manifestDescription;
        this.previewOnly = previewOnly;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="root_type")
    public ExportManifestRequestRootType getRootType() {
        return this.rootType;
    }

    @JsonProperty(value="root_ids")
    public List<String> getRootIds() {
        return this.rootIds;
    }

    @JsonProperty(value="include_downstream")
    public Optional<Boolean> getIncludeDownstream() {
        return this.includeDownstream;
    }

    @JsonProperty(value="manifest_name")
    public Optional<String> getManifestName() {
        return this.manifestName;
    }

    @JsonProperty(value="manifest_description")
    public Optional<String> getManifestDescription() {
        return this.manifestDescription;
    }

    @JsonProperty(value="preview_only")
    public Optional<Boolean> getPreviewOnly() {
        return this.previewOnly;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExportManifestRequest && this.equalTo((ExportManifestRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExportManifestRequest other) {
        return this.rootType.equals(other.rootType) && this.rootIds.equals(other.rootIds) && this.includeDownstream.equals(other.includeDownstream) && this.manifestName.equals(other.manifestName) && this.manifestDescription.equals(other.manifestDescription) && this.previewOnly.equals(other.previewOnly);
    }

    public int hashCode() {
        return Objects.hash(this.rootType, this.rootIds, this.includeDownstream, this.manifestName, this.manifestDescription, this.previewOnly);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RootTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RootTypeStage,
    _FinalStage {
        private ExportManifestRequestRootType rootType;
        private Optional<Boolean> previewOnly = Optional.empty();
        private Optional<String> manifestDescription = Optional.empty();
        private Optional<String> manifestName = Optional.empty();
        private Optional<Boolean> includeDownstream = Optional.empty();
        private List<String> rootIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ExportManifestRequest other) {
            this.rootType(other.getRootType());
            this.rootIds(other.getRootIds());
            this.includeDownstream(other.getIncludeDownstream());
            this.manifestName(other.getManifestName());
            this.manifestDescription(other.getManifestDescription());
            this.previewOnly(other.getPreviewOnly());
            return this;
        }

        @Override
        @JsonSetter(value="root_type")
        public _FinalStage rootType(@NotNull ExportManifestRequestRootType rootType) {
            this.rootType = Objects.requireNonNull(rootType, "rootType must not be null");
            return this;
        }

        @Override
        public _FinalStage previewOnly(Boolean previewOnly) {
            this.previewOnly = Optional.ofNullable(previewOnly);
            return this;
        }

        @Override
        @JsonSetter(value="preview_only", nulls=Nulls.SKIP)
        public _FinalStage previewOnly(Optional<Boolean> previewOnly) {
            this.previewOnly = previewOnly;
            return this;
        }

        @Override
        public _FinalStage manifestDescription(String manifestDescription) {
            this.manifestDescription = Optional.ofNullable(manifestDescription);
            return this;
        }

        @Override
        @JsonSetter(value="manifest_description", nulls=Nulls.SKIP)
        public _FinalStage manifestDescription(Optional<String> manifestDescription) {
            this.manifestDescription = manifestDescription;
            return this;
        }

        @Override
        public _FinalStage manifestName(String manifestName) {
            this.manifestName = Optional.ofNullable(manifestName);
            return this;
        }

        @Override
        @JsonSetter(value="manifest_name", nulls=Nulls.SKIP)
        public _FinalStage manifestName(Optional<String> manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        @Override
        public _FinalStage includeDownstream(Boolean includeDownstream) {
            this.includeDownstream = Optional.ofNullable(includeDownstream);
            return this;
        }

        @Override
        @JsonSetter(value="include_downstream", nulls=Nulls.SKIP)
        public _FinalStage includeDownstream(Optional<Boolean> includeDownstream) {
            this.includeDownstream = includeDownstream;
            return this;
        }

        @Override
        public _FinalStage addAllRootIds(List<String> rootIds) {
            if (rootIds != null) {
                this.rootIds.addAll(rootIds);
            }
            return this;
        }

        @Override
        public _FinalStage addRootIds(String rootIds) {
            this.rootIds.add(rootIds);
            return this;
        }

        @Override
        @JsonSetter(value="root_ids", nulls=Nulls.SKIP)
        public _FinalStage rootIds(List<String> rootIds) {
            this.rootIds.clear();
            if (rootIds != null) {
                this.rootIds.addAll(rootIds);
            }
            return this;
        }

        @Override
        public ExportManifestRequest build() {
            return new ExportManifestRequest(this.rootType, this.rootIds, this.includeDownstream, this.manifestName, this.manifestDescription, this.previewOnly, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ExportManifestRequest build();

        public _FinalStage rootIds(List<String> var1);

        public _FinalStage addRootIds(String var1);

        public _FinalStage addAllRootIds(List<String> var1);

        public _FinalStage includeDownstream(Optional<Boolean> var1);

        public _FinalStage includeDownstream(Boolean var1);

        public _FinalStage manifestName(Optional<String> var1);

        public _FinalStage manifestName(String var1);

        public _FinalStage manifestDescription(Optional<String> var1);

        public _FinalStage manifestDescription(String var1);

        public _FinalStage previewOnly(Optional<Boolean> var1);

        public _FinalStage previewOnly(Boolean var1);
    }

    public static interface RootTypeStage {
        public _FinalStage rootType(@NotNull ExportManifestRequestRootType var1);

        public Builder from(ExportManifestRequest var1);
    }
}

