/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.assets.types.ImportManifestRequestConflictStrategy;
import com.rulebricks.resources.assets.types.ImportManifestRequestLegacyRuleMappingValue;
import com.rulebricks.resources.assets.types.ImportManifestRequestManifest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ImportManifestRequest {
    private final ImportManifestRequestManifest manifest;
    private final Optional<ImportManifestRequestConflictStrategy> conflictStrategy;
    private final Optional<String> targetFolderName;
    private final Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> legacyRuleMapping;
    private final Map<String, Object> additionalProperties;

    private ImportManifestRequest(ImportManifestRequestManifest manifest, Optional<ImportManifestRequestConflictStrategy> conflictStrategy, Optional<String> targetFolderName, Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> legacyRuleMapping, Map<String, Object> additionalProperties) {
        this.manifest = manifest;
        this.conflictStrategy = conflictStrategy;
        this.targetFolderName = targetFolderName;
        this.legacyRuleMapping = legacyRuleMapping;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="manifest")
    public ImportManifestRequestManifest getManifest() {
        return this.manifest;
    }

    @JsonProperty(value="conflict_strategy")
    public Optional<ImportManifestRequestConflictStrategy> getConflictStrategy() {
        return this.conflictStrategy;
    }

    @JsonProperty(value="target_folder_name")
    public Optional<String> getTargetFolderName() {
        return this.targetFolderName;
    }

    @JsonProperty(value="legacy_rule_mapping")
    public Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> getLegacyRuleMapping() {
        return this.legacyRuleMapping;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ImportManifestRequest && this.equalTo((ImportManifestRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ImportManifestRequest other) {
        return this.manifest.equals(other.manifest) && this.conflictStrategy.equals(other.conflictStrategy) && this.targetFolderName.equals(other.targetFolderName) && this.legacyRuleMapping.equals(other.legacyRuleMapping);
    }

    public int hashCode() {
        return Objects.hash(this.manifest, this.conflictStrategy, this.targetFolderName, this.legacyRuleMapping);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ManifestStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ManifestStage,
    _FinalStage {
        private ImportManifestRequestManifest manifest;
        private Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> legacyRuleMapping = Optional.empty();
        private Optional<String> targetFolderName = Optional.empty();
        private Optional<ImportManifestRequestConflictStrategy> conflictStrategy = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ImportManifestRequest other) {
            this.manifest(other.getManifest());
            this.conflictStrategy(other.getConflictStrategy());
            this.targetFolderName(other.getTargetFolderName());
            this.legacyRuleMapping(other.getLegacyRuleMapping());
            return this;
        }

        @Override
        @JsonSetter(value="manifest")
        public _FinalStage manifest(@NotNull ImportManifestRequestManifest manifest) {
            this.manifest = Objects.requireNonNull(manifest, "manifest must not be null");
            return this;
        }

        @Override
        public _FinalStage legacyRuleMapping(Map<String, ImportManifestRequestLegacyRuleMappingValue> legacyRuleMapping) {
            this.legacyRuleMapping = Optional.ofNullable(legacyRuleMapping);
            return this;
        }

        @Override
        @JsonSetter(value="legacy_rule_mapping", nulls=Nulls.SKIP)
        public _FinalStage legacyRuleMapping(Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> legacyRuleMapping) {
            this.legacyRuleMapping = legacyRuleMapping;
            return this;
        }

        @Override
        public _FinalStage targetFolderName(String targetFolderName) {
            this.targetFolderName = Optional.ofNullable(targetFolderName);
            return this;
        }

        @Override
        @JsonSetter(value="target_folder_name", nulls=Nulls.SKIP)
        public _FinalStage targetFolderName(Optional<String> targetFolderName) {
            this.targetFolderName = targetFolderName;
            return this;
        }

        @Override
        public _FinalStage conflictStrategy(ImportManifestRequestConflictStrategy conflictStrategy) {
            this.conflictStrategy = Optional.ofNullable(conflictStrategy);
            return this;
        }

        @Override
        @JsonSetter(value="conflict_strategy", nulls=Nulls.SKIP)
        public _FinalStage conflictStrategy(Optional<ImportManifestRequestConflictStrategy> conflictStrategy) {
            this.conflictStrategy = conflictStrategy;
            return this;
        }

        @Override
        public ImportManifestRequest build() {
            return new ImportManifestRequest(this.manifest, this.conflictStrategy, this.targetFolderName, this.legacyRuleMapping, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ImportManifestRequest build();

        public _FinalStage conflictStrategy(Optional<ImportManifestRequestConflictStrategy> var1);

        public _FinalStage conflictStrategy(ImportManifestRequestConflictStrategy var1);

        public _FinalStage targetFolderName(Optional<String> var1);

        public _FinalStage targetFolderName(String var1);

        public _FinalStage legacyRuleMapping(Optional<Map<String, ImportManifestRequestLegacyRuleMappingValue>> var1);

        public _FinalStage legacyRuleMapping(Map<String, ImportManifestRequestLegacyRuleMappingValue> var1);
    }

    public static interface ManifestStage {
        public _FinalStage manifest(@NotNull ImportManifestRequestManifest var1);

        public Builder from(ImportManifestRequest var1);
    }
}

