/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.assets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ImportManifestRequestManifest {
    private final Optional<String> version;
    private final Optional<List<Map<String, Object>>> rules;
    private final Optional<List<Map<String, Object>>> flows;
    private final Optional<List<Map<String, Object>>> entities;
    private final Optional<List<Map<String, Object>>> values;
    private final Map<String, Object> additionalProperties;

    private ImportManifestRequestManifest(Optional<String> version, Optional<List<Map<String, Object>>> rules, Optional<List<Map<String, Object>>> flows, Optional<List<Map<String, Object>>> entities, Optional<List<Map<String, Object>>> values, Map<String, Object> additionalProperties) {
        this.version = version;
        this.rules = rules;
        this.flows = flows;
        this.entities = entities;
        this.values = values;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return this.version;
    }

    @JsonProperty(value="rules")
    public Optional<List<Map<String, Object>>> getRules() {
        return this.rules;
    }

    @JsonProperty(value="flows")
    public Optional<List<Map<String, Object>>> getFlows() {
        return this.flows;
    }

    @JsonProperty(value="entities")
    public Optional<List<Map<String, Object>>> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="values")
    public Optional<List<Map<String, Object>>> getValues() {
        return this.values;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ImportManifestRequestManifest && this.equalTo((ImportManifestRequestManifest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ImportManifestRequestManifest other) {
        return this.version.equals(other.version) && this.rules.equals(other.rules) && this.flows.equals(other.flows) && this.entities.equals(other.entities) && this.values.equals(other.values);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.rules, this.flows, this.entities, this.values);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> version = Optional.empty();
        private Optional<List<Map<String, Object>>> rules = Optional.empty();
        private Optional<List<Map<String, Object>>> flows = Optional.empty();
        private Optional<List<Map<String, Object>>> entities = Optional.empty();
        private Optional<List<Map<String, Object>>> values = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ImportManifestRequestManifest other) {
            this.version(other.getVersion());
            this.rules(other.getRules());
            this.flows(other.getFlows());
            this.entities(other.getEntities());
            this.values(other.getValues());
            return this;
        }

        @JsonSetter(value="version", nulls=Nulls.SKIP)
        public Builder version(Optional<String> version) {
            this.version = version;
            return this;
        }

        public Builder version(String version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        @JsonSetter(value="rules", nulls=Nulls.SKIP)
        public Builder rules(Optional<List<Map<String, Object>>> rules) {
            this.rules = rules;
            return this;
        }

        public Builder rules(List<Map<String, Object>> rules) {
            this.rules = Optional.ofNullable(rules);
            return this;
        }

        @JsonSetter(value="flows", nulls=Nulls.SKIP)
        public Builder flows(Optional<List<Map<String, Object>>> flows) {
            this.flows = flows;
            return this;
        }

        public Builder flows(List<Map<String, Object>> flows) {
            this.flows = Optional.ofNullable(flows);
            return this;
        }

        @JsonSetter(value="entities", nulls=Nulls.SKIP)
        public Builder entities(Optional<List<Map<String, Object>>> entities) {
            this.entities = entities;
            return this;
        }

        public Builder entities(List<Map<String, Object>> entities) {
            this.entities = Optional.ofNullable(entities);
            return this;
        }

        @JsonSetter(value="values", nulls=Nulls.SKIP)
        public Builder values(Optional<List<Map<String, Object>>> values) {
            this.values = values;
            return this;
        }

        public Builder values(List<Map<String, Object>> values) {
            this.values = Optional.ofNullable(values);
            return this;
        }

        public ImportManifestRequestManifest build() {
            return new ImportManifestRequestManifest(this.version, this.rules, this.flows, this.entities, this.values, this.additionalProperties);
        }
    }
}

