/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.Suppliers;
import com.rulebricks.resources.contexts.RawContextsClient;
import com.rulebricks.resources.contexts.objects.ObjectsClient;
import com.rulebricks.resources.contexts.relationships.RelationshipsClient;
import com.rulebricks.resources.contexts.requests.CascadeContextsRequest;
import com.rulebricks.resources.contexts.requests.DeleteContextsRequest;
import com.rulebricks.resources.contexts.requests.ExecuteContextsRequest;
import com.rulebricks.resources.contexts.requests.GetContextsRequest;
import com.rulebricks.resources.contexts.requests.GetHistoryContextsRequest;
import com.rulebricks.resources.contexts.requests.GetPendingContextsRequest;
import com.rulebricks.resources.contexts.requests.SolveContextsRequest;
import com.rulebricks.resources.contexts.requests.SubmitContextsRequest;
import com.rulebricks.types.CascadeContextResponse;
import com.rulebricks.types.ContextInstanceHistory;
import com.rulebricks.types.ContextInstancePendingResponse;
import com.rulebricks.types.ContextInstanceState;
import com.rulebricks.types.DeleteContextInstanceResponse;
import com.rulebricks.types.SolveContextFlowResponse;
import com.rulebricks.types.SolveContextRuleResponse;
import com.rulebricks.types.SubmitContextDataResponse;
import java.util.function.Supplier;

public class ContextsClient {
    protected final ClientOptions clientOptions;
    private final RawContextsClient rawClient;
    protected final Supplier<ObjectsClient> objectsClient;
    protected final Supplier<RelationshipsClient> relationshipsClient;

    public ContextsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawContextsClient(clientOptions);
        this.objectsClient = Suppliers.memoize(() -> new ObjectsClient(clientOptions));
        this.relationshipsClient = Suppliers.memoize(() -> new RelationshipsClient(clientOptions));
    }

    public RawContextsClient withRawResponse() {
        return this.rawClient;
    }

    public ContextInstanceState get(String slug, String instance) {
        return this.rawClient.get(slug, instance).body();
    }

    public ContextInstanceState get(String slug, String instance, GetContextsRequest request) {
        return this.rawClient.get(slug, instance, request).body();
    }

    public ContextInstanceState get(String slug, String instance, GetContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(slug, instance, request, requestOptions).body();
    }

    public SubmitContextDataResponse submit(String slug, String instance, SubmitContextsRequest request) {
        return this.rawClient.submit(slug, instance, request).body();
    }

    public SubmitContextDataResponse submit(String slug, String instance, SubmitContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.submit(slug, instance, request, requestOptions).body();
    }

    public DeleteContextInstanceResponse delete(String slug, String instance) {
        return this.rawClient.delete(slug, instance).body();
    }

    public DeleteContextInstanceResponse delete(String slug, String instance, DeleteContextsRequest request) {
        return this.rawClient.delete(slug, instance, request).body();
    }

    public DeleteContextInstanceResponse delete(String slug, String instance, DeleteContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(slug, instance, request, requestOptions).body();
    }

    public ContextInstanceHistory getHistory(String slug, String instance) {
        return this.rawClient.getHistory(slug, instance).body();
    }

    public ContextInstanceHistory getHistory(String slug, String instance, GetHistoryContextsRequest request) {
        return this.rawClient.getHistory(slug, instance, request).body();
    }

    public ContextInstanceHistory getHistory(String slug, String instance, GetHistoryContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.getHistory(slug, instance, request, requestOptions).body();
    }

    public ContextInstancePendingResponse getPending(String slug, String instance) {
        return this.rawClient.getPending(slug, instance).body();
    }

    public ContextInstancePendingResponse getPending(String slug, String instance, GetPendingContextsRequest request) {
        return this.rawClient.getPending(slug, instance, request).body();
    }

    public ContextInstancePendingResponse getPending(String slug, String instance, GetPendingContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.getPending(slug, instance, request, requestOptions).body();
    }

    public SolveContextRuleResponse solve(String slug, String instance, String ruleSlug, SolveContextsRequest request) {
        return this.rawClient.solve(slug, instance, ruleSlug, request).body();
    }

    public SolveContextRuleResponse solve(String slug, String instance, String ruleSlug, SolveContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.solve(slug, instance, ruleSlug, request, requestOptions).body();
    }

    public CascadeContextResponse cascade(String slug, String instance, CascadeContextsRequest request) {
        return this.rawClient.cascade(slug, instance, request).body();
    }

    public CascadeContextResponse cascade(String slug, String instance, CascadeContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.cascade(slug, instance, request, requestOptions).body();
    }

    public SolveContextFlowResponse execute(String slug, String instance, String flowSlug, ExecuteContextsRequest request) {
        return this.rawClient.execute(slug, instance, flowSlug, request).body();
    }

    public SolveContextFlowResponse execute(String slug, String instance, String flowSlug, ExecuteContextsRequest request, RequestOptions requestOptions) {
        return this.rawClient.execute(slug, instance, flowSlug, request, requestOptions).body();
    }

    public ObjectsClient objects() {
        return this.objectsClient.get();
    }

    public RelationshipsClient relationships() {
        return this.relationshipsClient.get();
    }
}

