/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.MediaTypes;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.QueryStringMapper;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.errors.BadRequestError;
import com.rulebricks.errors.InternalServerError;
import com.rulebricks.errors.NotFoundError;
import com.rulebricks.resources.contexts.requests.CascadeContextsRequest;
import com.rulebricks.resources.contexts.requests.DeleteContextsRequest;
import com.rulebricks.resources.contexts.requests.ExecuteContextsRequest;
import com.rulebricks.resources.contexts.requests.GetContextsRequest;
import com.rulebricks.resources.contexts.requests.GetHistoryContextsRequest;
import com.rulebricks.resources.contexts.requests.GetPendingContextsRequest;
import com.rulebricks.resources.contexts.requests.SolveContextsRequest;
import com.rulebricks.resources.contexts.requests.SubmitContextsRequest;
import com.rulebricks.types.CascadeContextResponse;
import com.rulebricks.types.ContextInstanceHistory;
import com.rulebricks.types.ContextInstancePendingResponse;
import com.rulebricks.types.ContextInstanceState;
import com.rulebricks.types.DeleteContextInstanceResponse;
import com.rulebricks.types.SolveContextFlowResponse;
import com.rulebricks.types.SolveContextRuleResponse;
import com.rulebricks.types.SubmitContextDataResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawContextsClient {
    protected final ClientOptions clientOptions;

    public RawContextsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public RulebricksApiHttpResponse<ContextInstanceState> get(String slug, String instance) {
        return this.get(slug, instance, GetContextsRequest.builder().build());
    }

    public RulebricksApiHttpResponse<ContextInstanceState> get(String slug, String instance, GetContextsRequest request) {
        return this.get(slug, instance, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<ContextInstanceState> get(String slug, String instance, GetContextsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("contexts").addPathSegment(slug).addPathSegment(instance).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<ContextInstanceState> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<ContextInstanceState>((ContextInstanceState)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContextInstanceState.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<SubmitContextDataResponse> submit(String slug, String instance, SubmitContextsRequest request) {
        return this.submit(slug, instance, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<SubmitContextDataResponse> submit(String slug, String instance, SubmitContextsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("contexts").addPathSegment(slug).addPathSegment(instance).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<SubmitContextDataResponse> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<SubmitContextDataResponse>((SubmitContextDataResponse)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SubmitContextDataResponse.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<DeleteContextInstanceResponse> delete(String slug, String instance) {
        return this.delete(slug, instance, DeleteContextsRequest.builder().build());
    }

    public RulebricksApiHttpResponse<DeleteContextInstanceResponse> delete(String slug, String instance, DeleteContextsRequest request) {
        return this.delete(slug, instance, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<DeleteContextInstanceResponse> delete(String slug, String instance, DeleteContextsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("contexts").addPathSegment(slug).addPathSegment(instance).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<DeleteContextInstanceResponse> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<DeleteContextInstanceResponse>((DeleteContextInstanceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DeleteContextInstanceResponse.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<ContextInstanceHistory> getHistory(String slug, String instance) {
        return this.getHistory(slug, instance, GetHistoryContextsRequest.builder().build());
    }

    public RulebricksApiHttpResponse<ContextInstanceHistory> getHistory(String slug, String instance, GetHistoryContextsRequest request) {
        return this.getHistory(slug, instance, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<ContextInstanceHistory> getHistory(String slug, String instance, GetHistoryContextsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("contexts").addPathSegment(slug).addPathSegment(instance).addPathSegments("history");
        if (request.getField().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "field", request.getField().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<ContextInstanceHistory> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<ContextInstanceHistory>((ContextInstanceHistory)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContextInstanceHistory.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<ContextInstancePendingResponse> getPending(String slug, String instance) {
        return this.getPending(slug, instance, GetPendingContextsRequest.builder().build());
    }

    public RulebricksApiHttpResponse<ContextInstancePendingResponse> getPending(String slug, String instance, GetPendingContextsRequest request) {
        return this.getPending(slug, instance, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<ContextInstancePendingResponse> getPending(String slug, String instance, GetPendingContextsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("contexts").addPathSegment(slug).addPathSegment(instance).addPathSegments("pending").build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<ContextInstancePendingResponse> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<ContextInstancePendingResponse>((ContextInstancePendingResponse)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, ContextInstancePendingResponse.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<SolveContextRuleResponse> solve(String slug, String instance, String ruleSlug, SolveContextsRequest request) {
        return this.solve(slug, instance, ruleSlug, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<SolveContextRuleResponse> solve(String slug, String instance, String ruleSlug, SolveContextsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("contexts").addPathSegment(slug).addPathSegment(instance).addPathSegments("solve").addPathSegment(ruleSlug).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<SolveContextRuleResponse> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<SolveContextRuleResponse>((SolveContextRuleResponse)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SolveContextRuleResponse.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<CascadeContextResponse> cascade(String slug, String instance, CascadeContextsRequest request) {
        return this.cascade(slug, instance, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<CascadeContextResponse> cascade(String slug, String instance, CascadeContextsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("contexts").addPathSegment(slug).addPathSegment(instance).addPathSegments("cascade").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<CascadeContextResponse> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<CascadeContextResponse>((CascadeContextResponse)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, CascadeContextResponse.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }

    public RulebricksApiHttpResponse<SolveContextFlowResponse> execute(String slug, String instance, String flowSlug, ExecuteContextsRequest request) {
        return this.execute(slug, instance, flowSlug, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RulebricksApiHttpResponse<SolveContextFlowResponse> execute(String slug, String instance, String flowSlug, ExecuteContextsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("contexts").addPathSegment(slug).addPathSegment(instance).addPathSegments("flows").addPathSegment(flowSlug).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new RulebricksApiException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                RulebricksApiHttpResponse<SolveContextFlowResponse> rulebricksApiHttpResponse = new RulebricksApiHttpResponse<SolveContextFlowResponse>((SolveContextFlowResponse)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, SolveContextFlowResponse.class), response);
                return rulebricksApiHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 500: {
                        throw new InternalServerError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new RulebricksApiException("Network error executing HTTP request", e);
        }
    }
}

