/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts.objects;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.contexts.objects.AsyncRawObjectsClient;
import com.rulebricks.resources.contexts.objects.requests.CreateContextRequest;
import com.rulebricks.resources.contexts.objects.requests.DeleteObjectsRequest;
import com.rulebricks.resources.contexts.objects.requests.GetObjectsRequest;
import com.rulebricks.resources.contexts.objects.requests.UpdateContextRequest;
import com.rulebricks.types.ContextDetail;
import com.rulebricks.types.ContextListItem;
import com.rulebricks.types.DeleteContextResponse;
import com.rulebricks.types.UpdateContextResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncObjectsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawObjectsClient rawClient;

    public AsyncObjectsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawObjectsClient(clientOptions);
    }

    public AsyncRawObjectsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<List<ContextListItem>> list() {
        return this.rawClient.list().thenApply(response -> (List)response.body());
    }

    public CompletableFuture<List<ContextListItem>> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (List)response.body());
    }

    public CompletableFuture<ContextDetail> create(CreateContextRequest request) {
        return this.rawClient.create(request).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> create(CreateContextRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> get(String id) {
        return this.rawClient.get(id).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> get(String id, GetObjectsRequest request) {
        return this.rawClient.get(id, request).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<ContextDetail> get(String id, GetObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(id, request, requestOptions).thenApply(response -> (ContextDetail)response.body());
    }

    public CompletableFuture<UpdateContextResponse> update(String id) {
        return this.rawClient.update(id).thenApply(response -> (UpdateContextResponse)response.body());
    }

    public CompletableFuture<UpdateContextResponse> update(String id, UpdateContextRequest request) {
        return this.rawClient.update(id, request).thenApply(response -> (UpdateContextResponse)response.body());
    }

    public CompletableFuture<UpdateContextResponse> update(String id, UpdateContextRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(id, request, requestOptions).thenApply(response -> (UpdateContextResponse)response.body());
    }

    public CompletableFuture<DeleteContextResponse> delete(String id) {
        return this.rawClient.delete(id).thenApply(response -> (DeleteContextResponse)response.body());
    }

    public CompletableFuture<DeleteContextResponse> delete(String id, DeleteObjectsRequest request) {
        return this.rawClient.delete(id, request).thenApply(response -> (DeleteContextResponse)response.body());
    }

    public CompletableFuture<DeleteContextResponse> delete(String id, DeleteObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(id, request, requestOptions).thenApply(response -> (DeleteContextResponse)response.body());
    }
}

