/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts.objects;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.contexts.objects.RawObjectsClient;
import com.rulebricks.resources.contexts.objects.requests.CreateContextRequest;
import com.rulebricks.resources.contexts.objects.requests.DeleteObjectsRequest;
import com.rulebricks.resources.contexts.objects.requests.GetObjectsRequest;
import com.rulebricks.resources.contexts.objects.requests.UpdateContextRequest;
import com.rulebricks.types.ContextDetail;
import com.rulebricks.types.ContextListItem;
import com.rulebricks.types.DeleteContextResponse;
import com.rulebricks.types.UpdateContextResponse;
import java.util.List;

public class ObjectsClient {
    protected final ClientOptions clientOptions;
    private final RawObjectsClient rawClient;

    public ObjectsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawObjectsClient(clientOptions);
    }

    public RawObjectsClient withRawResponse() {
        return this.rawClient;
    }

    public List<ContextListItem> list() {
        return this.rawClient.list().body();
    }

    public List<ContextListItem> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    public ContextDetail create(CreateContextRequest request) {
        return this.rawClient.create(request).body();
    }

    public ContextDetail create(CreateContextRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public ContextDetail get(String id) {
        return this.rawClient.get(id).body();
    }

    public ContextDetail get(String id, GetObjectsRequest request) {
        return this.rawClient.get(id, request).body();
    }

    public ContextDetail get(String id, GetObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(id, request, requestOptions).body();
    }

    public UpdateContextResponse update(String id) {
        return this.rawClient.update(id).body();
    }

    public UpdateContextResponse update(String id, UpdateContextRequest request) {
        return this.rawClient.update(id, request).body();
    }

    public UpdateContextResponse update(String id, UpdateContextRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(id, request, requestOptions).body();
    }

    public DeleteContextResponse delete(String id) {
        return this.rawClient.delete(id).body();
    }

    public DeleteContextResponse delete(String id, DeleteObjectsRequest request) {
        return this.rawClient.delete(id, request).body();
    }

    public DeleteContextResponse delete(String id, DeleteObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(id, request, requestOptions).body();
    }
}

