/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts.relationships.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.resources.contexts.relationships.types.CreateRelationshipRequestRelationType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateRelationshipRequest {
    private final String toContextId;
    private final CreateRelationshipRequestRelationType relationType;
    private final String foreignKeyFact;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private CreateRelationshipRequest(String toContextId, CreateRelationshipRequestRelationType relationType, String foreignKeyFact, Optional<String> name, Optional<String> description, Map<String, Object> additionalProperties) {
        this.toContextId = toContextId;
        this.relationType = relationType;
        this.foreignKeyFact = foreignKeyFact;
        this.name = name;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="to_context_id")
    public String getToContextId() {
        return this.toContextId;
    }

    @JsonProperty(value="relation_type")
    public CreateRelationshipRequestRelationType getRelationType() {
        return this.relationType;
    }

    @JsonProperty(value="foreign_key_fact")
    public String getForeignKeyFact() {
        return this.foreignKeyFact;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateRelationshipRequest && this.equalTo((CreateRelationshipRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateRelationshipRequest other) {
        return this.toContextId.equals(other.toContextId) && this.relationType.equals(other.relationType) && this.foreignKeyFact.equals(other.foreignKeyFact) && this.name.equals(other.name) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(this.toContextId, this.relationType, this.foreignKeyFact, this.name, this.description);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ToContextIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ToContextIdStage,
    RelationTypeStage,
    ForeignKeyFactStage,
    _FinalStage {
        private String toContextId;
        private CreateRelationshipRequestRelationType relationType;
        private String foreignKeyFact;
        private Optional<String> description = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateRelationshipRequest other) {
            this.toContextId(other.getToContextId());
            this.relationType(other.getRelationType());
            this.foreignKeyFact(other.getForeignKeyFact());
            this.name(other.getName());
            this.description(other.getDescription());
            return this;
        }

        @Override
        @JsonSetter(value="to_context_id")
        public RelationTypeStage toContextId(@NotNull String toContextId) {
            this.toContextId = Objects.requireNonNull(toContextId, "toContextId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="relation_type")
        public ForeignKeyFactStage relationType(@NotNull CreateRelationshipRequestRelationType relationType) {
            this.relationType = Objects.requireNonNull(relationType, "relationType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="foreign_key_fact")
        public _FinalStage foreignKeyFact(@NotNull String foreignKeyFact) {
            this.foreignKeyFact = Objects.requireNonNull(foreignKeyFact, "foreignKeyFact must not be null");
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public CreateRelationshipRequest build() {
            return new CreateRelationshipRequest(this.toContextId, this.relationType, this.foreignKeyFact, this.name, this.description, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateRelationshipRequest build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);
    }

    public static interface ForeignKeyFactStage {
        public _FinalStage foreignKeyFact(@NotNull String var1);
    }

    public static interface RelationTypeStage {
        public ForeignKeyFactStage relationType(@NotNull CreateRelationshipRequestRelationType var1);
    }

    public static interface ToContextIdStage {
        public RelationTypeStage toContextId(@NotNull String var1);

        public Builder from(CreateRelationshipRequest var1);
    }
}

