/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.contexts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetHistoryContextsRequest {
    private final Optional<String> field;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private GetHistoryContextsRequest(Optional<String> field, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.field = field;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="field")
    public Optional<String> getField() {
        return this.field;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetHistoryContextsRequest && this.equalTo((GetHistoryContextsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetHistoryContextsRequest other) {
        return this.field.equals(other.field) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> field = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(GetHistoryContextsRequest other) {
            this.field(other.getField());
            this.limit(other.getLimit());
            return this;
        }

        @JsonSetter(value="field", nulls=Nulls.SKIP)
        public Builder field(Optional<String> field) {
            this.field = field;
            return this;
        }

        public Builder field(String field) {
            this.field = Optional.ofNullable(field);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public GetHistoryContextsRequest build() {
            return new GetHistoryContextsRequest(this.field, this.limit, this.additionalProperties);
        }
    }
}

