/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.resources.values.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateValuesRequest {
    private final Map<String, Object> values;
    private final Optional<List<String>> userGroups;
    private final Map<String, Object> additionalProperties;

    private UpdateValuesRequest(Map<String, Object> values, Optional<List<String>> userGroups, Map<String, Object> additionalProperties) {
        this.values = values;
        this.userGroups = userGroups;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="values")
    public Map<String, Object> getValues() {
        return this.values;
    }

    @JsonProperty(value="user_groups")
    public Optional<List<String>> getUserGroups() {
        return this.userGroups;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateValuesRequest && this.equalTo((UpdateValuesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateValuesRequest other) {
        return this.values.equals(other.values) && this.userGroups.equals(other.userGroups);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.userGroups);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Map<String, Object> values = new LinkedHashMap<String, Object>();
        private Optional<List<String>> userGroups = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(UpdateValuesRequest other) {
            this.values(other.getValues());
            this.userGroups(other.getUserGroups());
            return this;
        }

        @JsonSetter(value="values", nulls=Nulls.SKIP)
        public Builder values(Map<String, Object> values) {
            this.values.clear();
            if (values != null) {
                this.values.putAll(values);
            }
            return this;
        }

        public Builder putAllValues(Map<String, Object> values) {
            if (values != null) {
                this.values.putAll(values);
            }
            return this;
        }

        public Builder values(String key, Object value) {
            this.values.put(key, value);
            return this;
        }

        @JsonSetter(value="user_groups", nulls=Nulls.SKIP)
        public Builder userGroups(Optional<List<String>> userGroups) {
            this.userGroups = userGroups;
            return this;
        }

        public Builder userGroups(List<String> userGroups) {
            this.userGroups = Optional.ofNullable(userGroups);
            return this;
        }

        public UpdateValuesRequest build() {
            return new UpdateValuesRequest(this.values, this.userGroups, this.additionalProperties);
        }
    }
}

