/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.CascadeResultStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CascadeResult {
    private final Optional<String> context;
    private final Optional<String> rule;
    private final Optional<String> flow;
    private final Optional<CascadeResultStatus> status;
    private final Optional<Map<String, Object>> result;
    private final Optional<Boolean> autoExecuted;
    private final Optional<List<String>> writtenToContext;
    private final Optional<String> error;
    private final Map<String, Object> additionalProperties;

    private CascadeResult(Optional<String> context, Optional<String> rule, Optional<String> flow, Optional<CascadeResultStatus> status, Optional<Map<String, Object>> result, Optional<Boolean> autoExecuted, Optional<List<String>> writtenToContext, Optional<String> error, Map<String, Object> additionalProperties) {
        this.context = context;
        this.rule = rule;
        this.flow = flow;
        this.status = status;
        this.result = result;
        this.autoExecuted = autoExecuted;
        this.writtenToContext = writtenToContext;
        this.error = error;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="context")
    public Optional<String> getContext() {
        return this.context;
    }

    @JsonIgnore
    public Optional<String> getRule() {
        if (this.rule == null) {
            return Optional.empty();
        }
        return this.rule;
    }

    @JsonIgnore
    public Optional<String> getFlow() {
        if (this.flow == null) {
            return Optional.empty();
        }
        return this.flow;
    }

    @JsonProperty(value="status")
    public Optional<CascadeResultStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="result")
    public Optional<Map<String, Object>> getResult() {
        return this.result;
    }

    @JsonProperty(value="auto_executed")
    public Optional<Boolean> getAutoExecuted() {
        return this.autoExecuted;
    }

    @JsonProperty(value="written_to_context")
    public Optional<List<String>> getWrittenToContext() {
        return this.writtenToContext;
    }

    @JsonIgnore
    public Optional<String> getError() {
        if (this.error == null) {
            return Optional.empty();
        }
        return this.error;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="rule")
    private Optional<String> _getRule() {
        return this.rule;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="flow")
    private Optional<String> _getFlow() {
        return this.flow;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="error")
    private Optional<String> _getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CascadeResult && this.equalTo((CascadeResult)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CascadeResult other) {
        return this.context.equals(other.context) && this.rule.equals(other.rule) && this.flow.equals(other.flow) && this.status.equals(other.status) && this.result.equals(other.result) && this.autoExecuted.equals(other.autoExecuted) && this.writtenToContext.equals(other.writtenToContext) && this.error.equals(other.error);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.rule, this.flow, this.status, this.result, this.autoExecuted, this.writtenToContext, this.error);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> context = Optional.empty();
        private Optional<String> rule = Optional.empty();
        private Optional<String> flow = Optional.empty();
        private Optional<CascadeResultStatus> status = Optional.empty();
        private Optional<Map<String, Object>> result = Optional.empty();
        private Optional<Boolean> autoExecuted = Optional.empty();
        private Optional<List<String>> writtenToContext = Optional.empty();
        private Optional<String> error = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CascadeResult other) {
            this.context(other.getContext());
            this.rule(other.getRule());
            this.flow(other.getFlow());
            this.status(other.getStatus());
            this.result(other.getResult());
            this.autoExecuted(other.getAutoExecuted());
            this.writtenToContext(other.getWrittenToContext());
            this.error(other.getError());
            return this;
        }

        @JsonSetter(value="context", nulls=Nulls.SKIP)
        public Builder context(Optional<String> context) {
            this.context = context;
            return this;
        }

        public Builder context(String context) {
            this.context = Optional.ofNullable(context);
            return this;
        }

        @JsonSetter(value="rule", nulls=Nulls.SKIP)
        public Builder rule(Optional<String> rule) {
            this.rule = rule;
            return this;
        }

        public Builder rule(String rule) {
            this.rule = Optional.ofNullable(rule);
            return this;
        }

        public Builder rule(Nullable<String> rule) {
            this.rule = rule.isNull() ? null : (rule.isEmpty() ? Optional.empty() : Optional.of(rule.get()));
            return this;
        }

        @JsonSetter(value="flow", nulls=Nulls.SKIP)
        public Builder flow(Optional<String> flow) {
            this.flow = flow;
            return this;
        }

        public Builder flow(String flow) {
            this.flow = Optional.ofNullable(flow);
            return this;
        }

        public Builder flow(Nullable<String> flow) {
            this.flow = flow.isNull() ? null : (flow.isEmpty() ? Optional.empty() : Optional.of(flow.get()));
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<CascadeResultStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(CascadeResultStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="result", nulls=Nulls.SKIP)
        public Builder result(Optional<Map<String, Object>> result) {
            this.result = result;
            return this;
        }

        public Builder result(Map<String, Object> result) {
            this.result = Optional.ofNullable(result);
            return this;
        }

        @JsonSetter(value="auto_executed", nulls=Nulls.SKIP)
        public Builder autoExecuted(Optional<Boolean> autoExecuted) {
            this.autoExecuted = autoExecuted;
            return this;
        }

        public Builder autoExecuted(Boolean autoExecuted) {
            this.autoExecuted = Optional.ofNullable(autoExecuted);
            return this;
        }

        @JsonSetter(value="written_to_context", nulls=Nulls.SKIP)
        public Builder writtenToContext(Optional<List<String>> writtenToContext) {
            this.writtenToContext = writtenToContext;
            return this;
        }

        public Builder writtenToContext(List<String> writtenToContext) {
            this.writtenToContext = Optional.ofNullable(writtenToContext);
            return this;
        }

        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public Builder error(Optional<String> error) {
            this.error = error;
            return this;
        }

        public Builder error(String error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        public Builder error(Nullable<String> error) {
            this.error = error.isNull() ? null : (error.isEmpty() ? Optional.empty() : Optional.of(error.get()));
            return this;
        }

        public CascadeResult build() {
            return new CascadeResult(this.context, this.rule, this.flow, this.status, this.result, this.autoExecuted, this.writtenToContext, this.error, this.additionalProperties);
        }
    }
}

