/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.ContextInstanceStateStatus;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContextInstanceState {
    private final Optional<String> context;
    private final Optional<Map<String, Object>> state;
    private final Optional<Map<String, Object>> derived;
    private final Optional<ContextInstanceStateStatus> status;
    private final Optional<List<String>> have;
    private final Optional<List<String>> need;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> updatedAt;
    private final Optional<OffsetDateTime> expiresAt;
    private final Map<String, Object> additionalProperties;

    private ContextInstanceState(Optional<String> context, Optional<Map<String, Object>> state, Optional<Map<String, Object>> derived, Optional<ContextInstanceStateStatus> status, Optional<List<String>> have, Optional<List<String>> need, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> updatedAt, Optional<OffsetDateTime> expiresAt, Map<String, Object> additionalProperties) {
        this.context = context;
        this.state = state;
        this.derived = derived;
        this.status = status;
        this.have = have;
        this.need = need;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.expiresAt = expiresAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="context")
    public Optional<String> getContext() {
        return this.context;
    }

    @JsonProperty(value="state")
    public Optional<Map<String, Object>> getState() {
        return this.state;
    }

    @JsonProperty(value="derived")
    public Optional<Map<String, Object>> getDerived() {
        return this.derived;
    }

    @JsonProperty(value="status")
    public Optional<ContextInstanceStateStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="have")
    public Optional<List<String>> getHave() {
        return this.have;
    }

    @JsonProperty(value="need")
    public Optional<List<String>> getNeed() {
        return this.need;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<OffsetDateTime> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getExpiresAt() {
        if (this.expiresAt == null) {
            return Optional.empty();
        }
        return this.expiresAt;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="expires_at")
    private Optional<OffsetDateTime> _getExpiresAt() {
        return this.expiresAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContextInstanceState && this.equalTo((ContextInstanceState)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContextInstanceState other) {
        return this.context.equals(other.context) && this.state.equals(other.state) && this.derived.equals(other.derived) && this.status.equals(other.status) && this.have.equals(other.have) && this.need.equals(other.need) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.expiresAt.equals(other.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.state, this.derived, this.status, this.have, this.need, this.createdAt, this.updatedAt, this.expiresAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> context = Optional.empty();
        private Optional<Map<String, Object>> state = Optional.empty();
        private Optional<Map<String, Object>> derived = Optional.empty();
        private Optional<ContextInstanceStateStatus> status = Optional.empty();
        private Optional<List<String>> have = Optional.empty();
        private Optional<List<String>> need = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> updatedAt = Optional.empty();
        private Optional<OffsetDateTime> expiresAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContextInstanceState other) {
            this.context(other.getContext());
            this.state(other.getState());
            this.derived(other.getDerived());
            this.status(other.getStatus());
            this.have(other.getHave());
            this.need(other.getNeed());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.expiresAt(other.getExpiresAt());
            return this;
        }

        @JsonSetter(value="context", nulls=Nulls.SKIP)
        public Builder context(Optional<String> context) {
            this.context = context;
            return this;
        }

        public Builder context(String context) {
            this.context = Optional.ofNullable(context);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<Map<String, Object>> state) {
            this.state = state;
            return this;
        }

        public Builder state(Map<String, Object> state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="derived", nulls=Nulls.SKIP)
        public Builder derived(Optional<Map<String, Object>> derived) {
            this.derived = derived;
            return this;
        }

        public Builder derived(Map<String, Object> derived) {
            this.derived = Optional.ofNullable(derived);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<ContextInstanceStateStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(ContextInstanceStateStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @JsonSetter(value="have", nulls=Nulls.SKIP)
        public Builder have(Optional<List<String>> have) {
            this.have = have;
            return this;
        }

        public Builder have(List<String> have) {
            this.have = Optional.ofNullable(have);
            return this;
        }

        @JsonSetter(value="need", nulls=Nulls.SKIP)
        public Builder need(Optional<List<String>> need) {
            this.need = need;
            return this;
        }

        public Builder need(List<String> need) {
            this.need = Optional.ofNullable(need);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="expires_at", nulls=Nulls.SKIP)
        public Builder expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public Builder expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        public Builder expiresAt(Nullable<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt.isNull() ? null : (expiresAt.isEmpty() ? Optional.empty() : Optional.of(expiresAt.get()));
            return this;
        }

        public ContextInstanceState build() {
            return new ContextInstanceState(this.context, this.state, this.derived, this.status, this.have, this.need, this.createdAt, this.updatedAt, this.expiresAt, this.additionalProperties);
        }
    }
}

