/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.ContextRelationshipIncoming;
import com.rulebricks.types.ContextRelationshipOutgoing;
import com.rulebricks.types.ContextRelationshipsResponseContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContextRelationshipsResponse {
    private final Optional<ContextRelationshipsResponseContext> context;
    private final Optional<List<ContextRelationshipOutgoing>> outgoing;
    private final Optional<List<ContextRelationshipIncoming>> incoming;
    private final Map<String, Object> additionalProperties;

    private ContextRelationshipsResponse(Optional<ContextRelationshipsResponseContext> context, Optional<List<ContextRelationshipOutgoing>> outgoing, Optional<List<ContextRelationshipIncoming>> incoming, Map<String, Object> additionalProperties) {
        this.context = context;
        this.outgoing = outgoing;
        this.incoming = incoming;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="context")
    public Optional<ContextRelationshipsResponseContext> getContext() {
        return this.context;
    }

    @JsonProperty(value="outgoing")
    public Optional<List<ContextRelationshipOutgoing>> getOutgoing() {
        return this.outgoing;
    }

    @JsonProperty(value="incoming")
    public Optional<List<ContextRelationshipIncoming>> getIncoming() {
        return this.incoming;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContextRelationshipsResponse && this.equalTo((ContextRelationshipsResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContextRelationshipsResponse other) {
        return this.context.equals(other.context) && this.outgoing.equals(other.outgoing) && this.incoming.equals(other.incoming);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.outgoing, this.incoming);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ContextRelationshipsResponseContext> context = Optional.empty();
        private Optional<List<ContextRelationshipOutgoing>> outgoing = Optional.empty();
        private Optional<List<ContextRelationshipIncoming>> incoming = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContextRelationshipsResponse other) {
            this.context(other.getContext());
            this.outgoing(other.getOutgoing());
            this.incoming(other.getIncoming());
            return this;
        }

        @JsonSetter(value="context", nulls=Nulls.SKIP)
        public Builder context(Optional<ContextRelationshipsResponseContext> context) {
            this.context = context;
            return this;
        }

        public Builder context(ContextRelationshipsResponseContext context) {
            this.context = Optional.ofNullable(context);
            return this;
        }

        @JsonSetter(value="outgoing", nulls=Nulls.SKIP)
        public Builder outgoing(Optional<List<ContextRelationshipOutgoing>> outgoing) {
            this.outgoing = outgoing;
            return this;
        }

        public Builder outgoing(List<ContextRelationshipOutgoing> outgoing) {
            this.outgoing = Optional.ofNullable(outgoing);
            return this;
        }

        @JsonSetter(value="incoming", nulls=Nulls.SKIP)
        public Builder incoming(Optional<List<ContextRelationshipIncoming>> incoming) {
            this.incoming = incoming;
            return this;
        }

        public Builder incoming(List<ContextRelationshipIncoming> incoming) {
            this.incoming = Optional.ofNullable(incoming);
            return this;
        }

        public ContextRelationshipsResponse build() {
            return new ContextRelationshipsResponse(this.context, this.outgoing, this.incoming, this.additionalProperties);
        }
    }
}

