/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.ContextSchemaFieldType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContextSchemaField {
    private final Optional<String> key;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<ContextSchemaFieldType> type;
    private final Optional<Object> defaultValue;
    private final Optional<Boolean> derived;
    private final Optional<String> sourceRule;
    private final Optional<String> sourceFlow;
    private final Optional<String> sourceField;
    private final Map<String, Object> additionalProperties;

    private ContextSchemaField(Optional<String> key, Optional<String> name, Optional<String> description, Optional<ContextSchemaFieldType> type, Optional<Object> defaultValue, Optional<Boolean> derived, Optional<String> sourceRule, Optional<String> sourceFlow, Optional<String> sourceField, Map<String, Object> additionalProperties) {
        this.key = key;
        this.name = name;
        this.description = description;
        this.type = type;
        this.defaultValue = defaultValue;
        this.derived = derived;
        this.sourceRule = sourceRule;
        this.sourceFlow = sourceFlow;
        this.sourceField = sourceField;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="key")
    public Optional<String> getKey() {
        return this.key;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="type")
    public Optional<ContextSchemaFieldType> getType() {
        return this.type;
    }

    @JsonIgnore
    public Optional<Object> getDefaultValue() {
        if (this.defaultValue == null) {
            return Optional.empty();
        }
        return this.defaultValue;
    }

    @JsonProperty(value="derived")
    public Optional<Boolean> getDerived() {
        return this.derived;
    }

    @JsonIgnore
    public Optional<String> getSourceRule() {
        if (this.sourceRule == null) {
            return Optional.empty();
        }
        return this.sourceRule;
    }

    @JsonIgnore
    public Optional<String> getSourceFlow() {
        if (this.sourceFlow == null) {
            return Optional.empty();
        }
        return this.sourceFlow;
    }

    @JsonIgnore
    public Optional<String> getSourceField() {
        if (this.sourceField == null) {
            return Optional.empty();
        }
        return this.sourceField;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="default_value")
    private Optional<Object> _getDefaultValue() {
        return this.defaultValue;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_rule")
    private Optional<String> _getSourceRule() {
        return this.sourceRule;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_flow")
    private Optional<String> _getSourceFlow() {
        return this.sourceFlow;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="source_field")
    private Optional<String> _getSourceField() {
        return this.sourceField;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContextSchemaField && this.equalTo((ContextSchemaField)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContextSchemaField other) {
        return this.key.equals(other.key) && this.name.equals(other.name) && this.description.equals(other.description) && this.type.equals(other.type) && this.defaultValue.equals(other.defaultValue) && this.derived.equals(other.derived) && this.sourceRule.equals(other.sourceRule) && this.sourceFlow.equals(other.sourceFlow) && this.sourceField.equals(other.sourceField);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.name, this.description, this.type, this.defaultValue, this.derived, this.sourceRule, this.sourceFlow, this.sourceField);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> key = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<ContextSchemaFieldType> type = Optional.empty();
        private Optional<Object> defaultValue = Optional.empty();
        private Optional<Boolean> derived = Optional.empty();
        private Optional<String> sourceRule = Optional.empty();
        private Optional<String> sourceFlow = Optional.empty();
        private Optional<String> sourceField = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContextSchemaField other) {
            this.key(other.getKey());
            this.name(other.getName());
            this.description(other.getDescription());
            this.type(other.getType());
            this.defaultValue(other.getDefaultValue());
            this.derived(other.getDerived());
            this.sourceRule(other.getSourceRule());
            this.sourceFlow(other.getSourceFlow());
            this.sourceField(other.getSourceField());
            return this;
        }

        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public Builder key(Optional<String> key) {
            this.key = key;
            return this;
        }

        public Builder key(String key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<ContextSchemaFieldType> type) {
            this.type = type;
            return this;
        }

        public Builder type(ContextSchemaFieldType type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="default_value", nulls=Nulls.SKIP)
        public Builder defaultValue(Optional<Object> defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = Optional.ofNullable(defaultValue);
            return this;
        }

        public Builder defaultValue(Nullable<Object> defaultValue) {
            this.defaultValue = defaultValue.isNull() ? null : (defaultValue.isEmpty() ? Optional.empty() : Optional.of(defaultValue.get()));
            return this;
        }

        @JsonSetter(value="derived", nulls=Nulls.SKIP)
        public Builder derived(Optional<Boolean> derived) {
            this.derived = derived;
            return this;
        }

        public Builder derived(Boolean derived) {
            this.derived = Optional.ofNullable(derived);
            return this;
        }

        @JsonSetter(value="source_rule", nulls=Nulls.SKIP)
        public Builder sourceRule(Optional<String> sourceRule) {
            this.sourceRule = sourceRule;
            return this;
        }

        public Builder sourceRule(String sourceRule) {
            this.sourceRule = Optional.ofNullable(sourceRule);
            return this;
        }

        public Builder sourceRule(Nullable<String> sourceRule) {
            this.sourceRule = sourceRule.isNull() ? null : (sourceRule.isEmpty() ? Optional.empty() : Optional.of(sourceRule.get()));
            return this;
        }

        @JsonSetter(value="source_flow", nulls=Nulls.SKIP)
        public Builder sourceFlow(Optional<String> sourceFlow) {
            this.sourceFlow = sourceFlow;
            return this;
        }

        public Builder sourceFlow(String sourceFlow) {
            this.sourceFlow = Optional.ofNullable(sourceFlow);
            return this;
        }

        public Builder sourceFlow(Nullable<String> sourceFlow) {
            this.sourceFlow = sourceFlow.isNull() ? null : (sourceFlow.isEmpty() ? Optional.empty() : Optional.of(sourceFlow.get()));
            return this;
        }

        @JsonSetter(value="source_field", nulls=Nulls.SKIP)
        public Builder sourceField(Optional<String> sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public Builder sourceField(String sourceField) {
            this.sourceField = Optional.ofNullable(sourceField);
            return this;
        }

        public Builder sourceField(Nullable<String> sourceField) {
            this.sourceField = sourceField.isNull() ? null : (sourceField.isEmpty() ? Optional.empty() : Optional.of(sourceField.get()));
            return this;
        }

        public ContextSchemaField build() {
            return new ContextSchemaField(this.key, this.name, this.description, this.type, this.defaultValue, this.derived, this.sourceRule, this.sourceFlow, this.sourceField, this.additionalProperties);
        }
    }
}

