/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class ContextSchemaFieldType {
    public static final ContextSchemaFieldType NUMBER = new ContextSchemaFieldType(Value.NUMBER, "number");
    public static final ContextSchemaFieldType STRING = new ContextSchemaFieldType(Value.STRING, "string");
    public static final ContextSchemaFieldType LIST = new ContextSchemaFieldType(Value.LIST, "list");
    public static final ContextSchemaFieldType FUNCTION = new ContextSchemaFieldType(Value.FUNCTION, "function");
    public static final ContextSchemaFieldType BOOLEAN = new ContextSchemaFieldType(Value.BOOLEAN, "boolean");
    public static final ContextSchemaFieldType DATE = new ContextSchemaFieldType(Value.DATE, "date");
    private final Value value;
    private final String string;

    ContextSchemaFieldType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ContextSchemaFieldType && this.string.equals(((ContextSchemaFieldType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case NUMBER: {
                return visitor.visitNumber();
            }
            case STRING: {
                return visitor.visitString();
            }
            case LIST: {
                return visitor.visitList();
            }
            case FUNCTION: {
                return visitor.visitFunction();
            }
            case BOOLEAN: {
                return visitor.visitBoolean();
            }
            case DATE: {
                return visitor.visitDate();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static ContextSchemaFieldType valueOf(String value) {
        switch (value) {
            case "number": {
                return NUMBER;
            }
            case "string": {
                return STRING;
            }
            case "list": {
                return LIST;
            }
            case "function": {
                return FUNCTION;
            }
            case "boolean": {
                return BOOLEAN;
            }
            case "date": {
                return DATE;
            }
        }
        return new ContextSchemaFieldType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitString();

        public T visitNumber();

        public T visitBoolean();

        public T visitDate();

        public T visitList();

        public T visitFunction();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        STRING,
        NUMBER,
        BOOLEAN,
        DATE,
        LIST,
        FUNCTION,
        UNKNOWN;

    }
}

