/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateUserResponseUser {
    private final Optional<String> id;
    private final Optional<String> email;
    private final Optional<String> name;
    private final Optional<String> role;
    private final Optional<List<String>> userGroups;
    private final Optional<String> apiKey;
    private final Map<String, Object> additionalProperties;

    private CreateUserResponseUser(Optional<String> id, Optional<String> email, Optional<String> name, Optional<String> role, Optional<List<String>> userGroups, Optional<String> apiKey, Map<String, Object> additionalProperties) {
        this.id = id;
        this.email = email;
        this.name = name;
        this.role = role;
        this.userGroups = userGroups;
        this.apiKey = apiKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonIgnore
    public Optional<String> getName() {
        if (this.name == null) {
            return Optional.empty();
        }
        return this.name;
    }

    @JsonProperty(value="role")
    public Optional<String> getRole() {
        return this.role;
    }

    @JsonProperty(value="user_groups")
    public Optional<List<String>> getUserGroups() {
        return this.userGroups;
    }

    @JsonIgnore
    public Optional<String> getApiKey() {
        if (this.apiKey == null) {
            return Optional.empty();
        }
        return this.apiKey;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="name")
    private Optional<String> _getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="api_key")
    private Optional<String> _getApiKey() {
        return this.apiKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateUserResponseUser && this.equalTo((CreateUserResponseUser)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateUserResponseUser other) {
        return this.id.equals(other.id) && this.email.equals(other.email) && this.name.equals(other.name) && this.role.equals(other.role) && this.userGroups.equals(other.userGroups) && this.apiKey.equals(other.apiKey);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.email, this.name, this.role, this.userGroups, this.apiKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> role = Optional.empty();
        private Optional<List<String>> userGroups = Optional.empty();
        private Optional<String> apiKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CreateUserResponseUser other) {
            this.id(other.getId());
            this.email(other.getEmail());
            this.name(other.getName());
            this.role(other.getRole());
            this.userGroups(other.getUserGroups());
            this.apiKey(other.getApiKey());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Nullable<String> name) {
            this.name = name.isNull() ? null : (name.isEmpty() ? Optional.empty() : Optional.of(name.get()));
            return this;
        }

        @JsonSetter(value="role", nulls=Nulls.SKIP)
        public Builder role(Optional<String> role) {
            this.role = role;
            return this;
        }

        public Builder role(String role) {
            this.role = Optional.ofNullable(role);
            return this;
        }

        @JsonSetter(value="user_groups", nulls=Nulls.SKIP)
        public Builder userGroups(Optional<List<String>> userGroups) {
            this.userGroups = userGroups;
            return this;
        }

        public Builder userGroups(List<String> userGroups) {
            this.userGroups = Optional.ofNullable(userGroups);
            return this;
        }

        @JsonSetter(value="api_key", nulls=Nulls.SKIP)
        public Builder apiKey(Optional<String> apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = Optional.ofNullable(apiKey);
            return this;
        }

        public Builder apiKey(Nullable<String> apiKey) {
            this.apiKey = apiKey.isNull() ? null : (apiKey.isEmpty() ? Optional.empty() : Optional.of(apiKey.get()));
            return this;
        }

        public CreateUserResponseUser build() {
            return new CreateUserResponseUser(this.id, this.email, this.name, this.role, this.userGroups, this.apiKey, this.additionalProperties);
        }
    }
}

