/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.ExportManifestResponseManifest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ExportManifestResponse {
    private final Optional<Boolean> success;
    private final Optional<ExportManifestResponseManifest> manifest;
    private final Optional<String> error;
    private final Map<String, Object> additionalProperties;

    private ExportManifestResponse(Optional<Boolean> success, Optional<ExportManifestResponseManifest> manifest, Optional<String> error, Map<String, Object> additionalProperties) {
        this.success = success;
        this.manifest = manifest;
        this.error = error;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="success")
    public Optional<Boolean> getSuccess() {
        return this.success;
    }

    @JsonProperty(value="manifest")
    public Optional<ExportManifestResponseManifest> getManifest() {
        return this.manifest;
    }

    @JsonProperty(value="error")
    public Optional<String> getError() {
        return this.error;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExportManifestResponse && this.equalTo((ExportManifestResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExportManifestResponse other) {
        return this.success.equals(other.success) && this.manifest.equals(other.manifest) && this.error.equals(other.error);
    }

    public int hashCode() {
        return Objects.hash(this.success, this.manifest, this.error);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> success = Optional.empty();
        private Optional<ExportManifestResponseManifest> manifest = Optional.empty();
        private Optional<String> error = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ExportManifestResponse other) {
            this.success(other.getSuccess());
            this.manifest(other.getManifest());
            this.error(other.getError());
            return this;
        }

        @JsonSetter(value="success", nulls=Nulls.SKIP)
        public Builder success(Optional<Boolean> success) {
            this.success = success;
            return this;
        }

        public Builder success(Boolean success) {
            this.success = Optional.ofNullable(success);
            return this;
        }

        @JsonSetter(value="manifest", nulls=Nulls.SKIP)
        public Builder manifest(Optional<ExportManifestResponseManifest> manifest) {
            this.manifest = manifest;
            return this;
        }

        public Builder manifest(ExportManifestResponseManifest manifest) {
            this.manifest = Optional.ofNullable(manifest);
            return this;
        }

        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public Builder error(Optional<String> error) {
            this.error = error;
            return this;
        }

        public Builder error(String error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        public ExportManifestResponse build() {
            return new ExportManifestResponse(this.success, this.manifest, this.error, this.additionalProperties);
        }
    }
}

