/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.Folder;
import com.rulebricks.types.IRuleBase;
import com.rulebricks.types.RuleDetailContext;
import com.rulebricks.types.SchemaField;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RuleDetail
implements IRuleBase {
    private final Optional<String> id;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<String> slug;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> updatedAt;
    private final Optional<Folder> folder;
    private final Optional<RuleDetailContext> context;
    private final Optional<List<SchemaField>> requestSchema;
    private final Optional<List<SchemaField>> responseSchema;
    private final Map<String, Object> additionalProperties;

    private RuleDetail(Optional<String> id, Optional<String> name, Optional<String> description, Optional<String> slug, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> updatedAt, Optional<Folder> folder, Optional<RuleDetailContext> context, Optional<List<SchemaField>> requestSchema, Optional<List<SchemaField>> responseSchema, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.slug = slug;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.folder = folder;
        this.context = context;
        this.requestSchema = requestSchema;
        this.responseSchema = responseSchema;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="slug")
    public Optional<String> getSlug() {
        return this.slug;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<OffsetDateTime> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="folder")
    public Optional<Folder> getFolder() {
        return this.folder;
    }

    @JsonIgnore
    public Optional<RuleDetailContext> getContext() {
        if (this.context == null) {
            return Optional.empty();
        }
        return this.context;
    }

    @JsonProperty(value="request_schema")
    public Optional<List<SchemaField>> getRequestSchema() {
        return this.requestSchema;
    }

    @JsonProperty(value="response_schema")
    public Optional<List<SchemaField>> getResponseSchema() {
        return this.responseSchema;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="context")
    private Optional<RuleDetailContext> _getContext() {
        return this.context;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RuleDetail && this.equalTo((RuleDetail)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RuleDetail other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.description.equals(other.description) && this.slug.equals(other.slug) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt) && this.folder.equals(other.folder) && this.context.equals(other.context) && this.requestSchema.equals(other.requestSchema) && this.responseSchema.equals(other.responseSchema);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.slug, this.createdAt, this.updatedAt, this.folder, this.context, this.requestSchema, this.responseSchema);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> slug = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> updatedAt = Optional.empty();
        private Optional<Folder> folder = Optional.empty();
        private Optional<RuleDetailContext> context = Optional.empty();
        private Optional<List<SchemaField>> requestSchema = Optional.empty();
        private Optional<List<SchemaField>> responseSchema = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RuleDetail other) {
            this.id(other.getId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.slug(other.getSlug());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.folder(other.getFolder());
            this.context(other.getContext());
            this.requestSchema(other.getRequestSchema());
            this.responseSchema(other.getResponseSchema());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value="slug", nulls=Nulls.SKIP)
        public Builder slug(Optional<String> slug) {
            this.slug = slug;
            return this;
        }

        public Builder slug(String slug) {
            this.slug = Optional.ofNullable(slug);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(OffsetDateTime updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="folder", nulls=Nulls.SKIP)
        public Builder folder(Optional<Folder> folder) {
            this.folder = folder;
            return this;
        }

        public Builder folder(Folder folder) {
            this.folder = Optional.ofNullable(folder);
            return this;
        }

        @JsonSetter(value="context", nulls=Nulls.SKIP)
        public Builder context(Optional<RuleDetailContext> context) {
            this.context = context;
            return this;
        }

        public Builder context(RuleDetailContext context) {
            this.context = Optional.ofNullable(context);
            return this;
        }

        public Builder context(Nullable<RuleDetailContext> context) {
            this.context = context.isNull() ? null : (context.isEmpty() ? Optional.empty() : Optional.of(context.get()));
            return this;
        }

        @JsonSetter(value="request_schema", nulls=Nulls.SKIP)
        public Builder requestSchema(Optional<List<SchemaField>> requestSchema) {
            this.requestSchema = requestSchema;
            return this;
        }

        public Builder requestSchema(List<SchemaField> requestSchema) {
            this.requestSchema = Optional.ofNullable(requestSchema);
            return this;
        }

        @JsonSetter(value="response_schema", nulls=Nulls.SKIP)
        public Builder responseSchema(Optional<List<SchemaField>> responseSchema) {
            this.responseSchema = responseSchema;
            return this;
        }

        public Builder responseSchema(List<SchemaField> responseSchema) {
            this.responseSchema = Optional.ofNullable(responseSchema);
            return this;
        }

        public RuleDetail build() {
            return new RuleDetail(this.id, this.name, this.description, this.slug, this.createdAt, this.updatedAt, this.folder, this.context, this.requestSchema, this.responseSchema, this.additionalProperties);
        }
    }
}

