/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class SchemaFieldType {
    public static final SchemaFieldType NUMBER = new SchemaFieldType(Value.NUMBER, "number");
    public static final SchemaFieldType STRING = new SchemaFieldType(Value.STRING, "string");
    public static final SchemaFieldType BOOLEAN = new SchemaFieldType(Value.BOOLEAN, "boolean");
    public static final SchemaFieldType OBJECT = new SchemaFieldType(Value.OBJECT, "object");
    public static final SchemaFieldType ARRAY = new SchemaFieldType(Value.ARRAY, "array");
    private final Value value;
    private final String string;

    SchemaFieldType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SchemaFieldType && this.string.equals(((SchemaFieldType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case NUMBER: {
                return visitor.visitNumber();
            }
            case STRING: {
                return visitor.visitString();
            }
            case BOOLEAN: {
                return visitor.visitBoolean();
            }
            case OBJECT: {
                return visitor.visitObject();
            }
            case ARRAY: {
                return visitor.visitArray();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static SchemaFieldType valueOf(String value) {
        switch (value) {
            case "number": {
                return NUMBER;
            }
            case "string": {
                return STRING;
            }
            case "boolean": {
                return BOOLEAN;
            }
            case "object": {
                return OBJECT;
            }
            case "array": {
                return ARRAY;
            }
        }
        return new SchemaFieldType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitString();

        public T visitNumber();

        public T visitBoolean();

        public T visitObject();

        public T visitArray();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        STRING,
        NUMBER,
        BOOLEAN,
        OBJECT,
        ARRAY,
        UNKNOWN;

    }
}

