/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.TestTestState;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Test {
    private final String id;
    private final String name;
    private final Map<String, Object> request;
    private final Map<String, Object> response;
    private final boolean critical;
    private final Optional<Boolean> error;
    private final Optional<Boolean> success;
    private final Optional<TestTestState> testState;
    private final Optional<OffsetDateTime> lastExecuted;
    private final Map<String, Object> additionalProperties;

    private Test(String id, String name, Map<String, Object> request, Map<String, Object> response, boolean critical, Optional<Boolean> error, Optional<Boolean> success, Optional<TestTestState> testState, Optional<OffsetDateTime> lastExecuted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.request = request;
        this.response = response;
        this.critical = critical;
        this.error = error;
        this.success = success;
        this.testState = testState;
        this.lastExecuted = lastExecuted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="request")
    public Map<String, Object> getRequest() {
        return this.request;
    }

    @JsonProperty(value="response")
    public Map<String, Object> getResponse() {
        return this.response;
    }

    @JsonProperty(value="critical")
    public boolean getCritical() {
        return this.critical;
    }

    @JsonIgnore
    public Optional<Boolean> getError() {
        if (this.error == null) {
            return Optional.empty();
        }
        return this.error;
    }

    @JsonIgnore
    public Optional<Boolean> getSuccess() {
        if (this.success == null) {
            return Optional.empty();
        }
        return this.success;
    }

    @JsonIgnore
    public Optional<TestTestState> getTestState() {
        if (this.testState == null) {
            return Optional.empty();
        }
        return this.testState;
    }

    @JsonIgnore
    public Optional<OffsetDateTime> getLastExecuted() {
        if (this.lastExecuted == null) {
            return Optional.empty();
        }
        return this.lastExecuted;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="error")
    private Optional<Boolean> _getError() {
        return this.error;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="success")
    private Optional<Boolean> _getSuccess() {
        return this.success;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="test_state")
    private Optional<TestTestState> _getTestState() {
        return this.testState;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="last_executed")
    private Optional<OffsetDateTime> _getLastExecuted() {
        return this.lastExecuted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Test && this.equalTo((Test)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Test other) {
        return this.id.equals(other.id) && this.name.equals(other.name) && this.request.equals(other.request) && this.response.equals(other.response) && this.critical == other.critical && this.error.equals(other.error) && this.success.equals(other.success) && this.testState.equals(other.testState) && this.lastExecuted.equals(other.lastExecuted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.request, this.response, this.critical, this.error, this.success, this.testState, this.lastExecuted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    CriticalStage,
    _FinalStage {
        private String id;
        private String name;
        private boolean critical;
        private Optional<OffsetDateTime> lastExecuted = Optional.empty();
        private Optional<TestTestState> testState = Optional.empty();
        private Optional<Boolean> success = Optional.empty();
        private Optional<Boolean> error = Optional.empty();
        private Map<String, Object> response = new LinkedHashMap<String, Object>();
        private Map<String, Object> request = new LinkedHashMap<String, Object>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Test other) {
            this.id(other.getId());
            this.name(other.getName());
            this.request(other.getRequest());
            this.response(other.getResponse());
            this.critical(other.getCritical());
            this.error(other.getError());
            this.success(other.getSuccess());
            this.testState(other.getTestState());
            this.lastExecuted(other.getLastExecuted());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public CriticalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="critical")
        public _FinalStage critical(boolean critical) {
            this.critical = critical;
            return this;
        }

        @Override
        public _FinalStage lastExecuted(Nullable<OffsetDateTime> lastExecuted) {
            this.lastExecuted = lastExecuted.isNull() ? null : (lastExecuted.isEmpty() ? Optional.empty() : Optional.of(lastExecuted.get()));
            return this;
        }

        @Override
        public _FinalStage lastExecuted(OffsetDateTime lastExecuted) {
            this.lastExecuted = Optional.ofNullable(lastExecuted);
            return this;
        }

        @Override
        @JsonSetter(value="last_executed", nulls=Nulls.SKIP)
        public _FinalStage lastExecuted(Optional<OffsetDateTime> lastExecuted) {
            this.lastExecuted = lastExecuted;
            return this;
        }

        @Override
        public _FinalStage testState(Nullable<TestTestState> testState) {
            this.testState = testState.isNull() ? null : (testState.isEmpty() ? Optional.empty() : Optional.of(testState.get()));
            return this;
        }

        @Override
        public _FinalStage testState(TestTestState testState) {
            this.testState = Optional.ofNullable(testState);
            return this;
        }

        @Override
        @JsonSetter(value="test_state", nulls=Nulls.SKIP)
        public _FinalStage testState(Optional<TestTestState> testState) {
            this.testState = testState;
            return this;
        }

        @Override
        public _FinalStage success(Nullable<Boolean> success) {
            this.success = success.isNull() ? null : (success.isEmpty() ? Optional.empty() : Optional.of(success.get()));
            return this;
        }

        @Override
        public _FinalStage success(Boolean success) {
            this.success = Optional.ofNullable(success);
            return this;
        }

        @Override
        @JsonSetter(value="success", nulls=Nulls.SKIP)
        public _FinalStage success(Optional<Boolean> success) {
            this.success = success;
            return this;
        }

        @Override
        public _FinalStage error(Nullable<Boolean> error) {
            this.error = error.isNull() ? null : (error.isEmpty() ? Optional.empty() : Optional.of(error.get()));
            return this;
        }

        @Override
        public _FinalStage error(Boolean error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        @Override
        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public _FinalStage error(Optional<Boolean> error) {
            this.error = error;
            return this;
        }

        @Override
        public _FinalStage response(String key, Object value) {
            this.response.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllResponse(Map<String, Object> response) {
            if (response != null) {
                this.response.putAll(response);
            }
            return this;
        }

        @Override
        @JsonSetter(value="response", nulls=Nulls.SKIP)
        public _FinalStage response(Map<String, Object> response) {
            this.response.clear();
            if (response != null) {
                this.response.putAll(response);
            }
            return this;
        }

        @Override
        public _FinalStage request(String key, Object value) {
            this.request.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllRequest(Map<String, Object> request) {
            if (request != null) {
                this.request.putAll(request);
            }
            return this;
        }

        @Override
        @JsonSetter(value="request", nulls=Nulls.SKIP)
        public _FinalStage request(Map<String, Object> request) {
            this.request.clear();
            if (request != null) {
                this.request.putAll(request);
            }
            return this;
        }

        @Override
        public Test build() {
            return new Test(this.id, this.name, this.request, this.response, this.critical, this.error, this.success, this.testState, this.lastExecuted, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Test build();

        public _FinalStage request(Map<String, Object> var1);

        public _FinalStage putAllRequest(Map<String, Object> var1);

        public _FinalStage request(String var1, Object var2);

        public _FinalStage response(Map<String, Object> var1);

        public _FinalStage putAllResponse(Map<String, Object> var1);

        public _FinalStage response(String var1, Object var2);

        public _FinalStage error(Optional<Boolean> var1);

        public _FinalStage error(Boolean var1);

        public _FinalStage error(Nullable<Boolean> var1);

        public _FinalStage success(Optional<Boolean> var1);

        public _FinalStage success(Boolean var1);

        public _FinalStage success(Nullable<Boolean> var1);

        public _FinalStage testState(Optional<TestTestState> var1);

        public _FinalStage testState(TestTestState var1);

        public _FinalStage testState(Nullable<TestTestState> var1);

        public _FinalStage lastExecuted(Optional<OffsetDateTime> var1);

        public _FinalStage lastExecuted(OffsetDateTime var1);

        public _FinalStage lastExecuted(Nullable<OffsetDateTime> var1);
    }

    public static interface CriticalStage {
        public _FinalStage critical(boolean var1);
    }

    public static interface NameStage {
        public CriticalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(Test var1);
    }
}

