/*
 * Decompiled with CFR 0.152.
 */
package com.rulebricks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rulebricks.core.Nullable;
import com.rulebricks.core.NullableNonemptyFilter;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.types.TestTestStateEvaluationError;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TestTestState {
    private final Optional<Double> duration;
    private final Optional<Map<String, Object>> response;
    private final Optional<List<Map<String, Object>>> conditions;
    private final Optional<Integer> httpStatus;
    private final Optional<List<Integer>> successIdxs;
    private final Optional<TestTestStateEvaluationError> evaluationError;
    private final Map<String, Object> additionalProperties;

    private TestTestState(Optional<Double> duration, Optional<Map<String, Object>> response, Optional<List<Map<String, Object>>> conditions, Optional<Integer> httpStatus, Optional<List<Integer>> successIdxs, Optional<TestTestStateEvaluationError> evaluationError, Map<String, Object> additionalProperties) {
        this.duration = duration;
        this.response = response;
        this.conditions = conditions;
        this.httpStatus = httpStatus;
        this.successIdxs = successIdxs;
        this.evaluationError = evaluationError;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="duration")
    public Optional<Double> getDuration() {
        return this.duration;
    }

    @JsonIgnore
    public Optional<Map<String, Object>> getResponse() {
        if (this.response == null) {
            return Optional.empty();
        }
        return this.response;
    }

    @JsonProperty(value="conditions")
    public Optional<List<Map<String, Object>>> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="http_status")
    public Optional<Integer> getHttpStatus() {
        return this.httpStatus;
    }

    @JsonProperty(value="success_idxs")
    public Optional<List<Integer>> getSuccessIdxs() {
        return this.successIdxs;
    }

    @JsonProperty(value="evaluation_error")
    public Optional<TestTestStateEvaluationError> getEvaluationError() {
        return this.evaluationError;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="response")
    private Optional<Map<String, Object>> _getResponse() {
        return this.response;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TestTestState && this.equalTo((TestTestState)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TestTestState other) {
        return this.duration.equals(other.duration) && this.response.equals(other.response) && this.conditions.equals(other.conditions) && this.httpStatus.equals(other.httpStatus) && this.successIdxs.equals(other.successIdxs) && this.evaluationError.equals(other.evaluationError);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.response, this.conditions, this.httpStatus, this.successIdxs, this.evaluationError);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Double> duration = Optional.empty();
        private Optional<Map<String, Object>> response = Optional.empty();
        private Optional<List<Map<String, Object>>> conditions = Optional.empty();
        private Optional<Integer> httpStatus = Optional.empty();
        private Optional<List<Integer>> successIdxs = Optional.empty();
        private Optional<TestTestStateEvaluationError> evaluationError = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TestTestState other) {
            this.duration(other.getDuration());
            this.response(other.getResponse());
            this.conditions(other.getConditions());
            this.httpStatus(other.getHttpStatus());
            this.successIdxs(other.getSuccessIdxs());
            this.evaluationError(other.getEvaluationError());
            return this;
        }

        @JsonSetter(value="duration", nulls=Nulls.SKIP)
        public Builder duration(Optional<Double> duration) {
            this.duration = duration;
            return this;
        }

        public Builder duration(Double duration) {
            this.duration = Optional.ofNullable(duration);
            return this;
        }

        @JsonSetter(value="response", nulls=Nulls.SKIP)
        public Builder response(Optional<Map<String, Object>> response) {
            this.response = response;
            return this;
        }

        public Builder response(Map<String, Object> response) {
            this.response = Optional.ofNullable(response);
            return this;
        }

        public Builder response(Nullable<Map<String, Object>> response) {
            this.response = response.isNull() ? null : (response.isEmpty() ? Optional.empty() : Optional.of(response.get()));
            return this;
        }

        @JsonSetter(value="conditions", nulls=Nulls.SKIP)
        public Builder conditions(Optional<List<Map<String, Object>>> conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder conditions(List<Map<String, Object>> conditions) {
            this.conditions = Optional.ofNullable(conditions);
            return this;
        }

        @JsonSetter(value="http_status", nulls=Nulls.SKIP)
        public Builder httpStatus(Optional<Integer> httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public Builder httpStatus(Integer httpStatus) {
            this.httpStatus = Optional.ofNullable(httpStatus);
            return this;
        }

        @JsonSetter(value="success_idxs", nulls=Nulls.SKIP)
        public Builder successIdxs(Optional<List<Integer>> successIdxs) {
            this.successIdxs = successIdxs;
            return this;
        }

        public Builder successIdxs(List<Integer> successIdxs) {
            this.successIdxs = Optional.ofNullable(successIdxs);
            return this;
        }

        @JsonSetter(value="evaluation_error", nulls=Nulls.SKIP)
        public Builder evaluationError(Optional<TestTestStateEvaluationError> evaluationError) {
            this.evaluationError = evaluationError;
            return this;
        }

        public Builder evaluationError(TestTestStateEvaluationError evaluationError) {
            this.evaluationError = Optional.ofNullable(evaluationError);
            return this;
        }

        public TestTestState build() {
            return new TestTestState(this.duration, this.response, this.conditions, this.httpStatus, this.successIdxs, this.evaluationError, this.additionalProperties);
        }
    }
}

