/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.executors.rightvalues.AbstractPrimitiveRightValue;
import com.scriptbasic.spi.RightValue;
import com.scriptbasic.utility.NoInstance;
import java.util.List;
import java.util.function.Function;

public final class CastUtility {
    private static final List<P> converters = List.of(P.of(Byte.TYPE, Byte.class, object -> ((Number)object).byteValue()), P.of(Short.TYPE, Short.class, object -> ((Number)object).shortValue()), P.of(Integer.TYPE, Integer.class, object -> ((Number)object).intValue()), P.of(Long.TYPE, Long.class, object -> ((Number)object).longValue()), P.of(Float.TYPE, Float.class, object -> Float.valueOf(((Number)object).floatValue())), P.of(Double.TYPE, Double.class, object -> ((Number)object).doubleValue()), P.of(Character.TYPE, Character.class, object -> Character.valueOf((char)((Number)object).intValue())));

    private CastUtility() {
        NoInstance.isPossible();
    }

    public static Object cast(Object object, Class<?> castTo) {
        try {
            return converters.stream().filter(p -> p.primitive == castTo || p.objectClass == castTo).map(p -> p.converter.apply(object)).findFirst().orElse(object);
        }
        catch (ClassCastException cce) {
            return object;
        }
    }

    public static Object toObject(RightValue rightValue) {
        return rightValue == null ? null : ((AbstractPrimitiveRightValue)rightValue).getValue();
    }

    private static class P {
        final Class<?> primitive;
        final Class<?> objectClass;
        final Function<Object, Object> converter;

        private P(Class<?> primitive, Class<?> objectClass, Function<Object, Object> converter) {
            this.primitive = primitive;
            this.objectClass = objectClass;
            this.converter = converter;
        }

        static P of(Class<?> primitive, Class<?> objectClass, Function<Object, Object> converter) {
            return new P(primitive, objectClass, converter);
        }
    }
}

