/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.commands;

import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.executors.commands.AbstractCommandSelectPart;
import com.scriptbasic.executors.commands.CommandCase;
import com.scriptbasic.executors.commands.CommandEndSelect;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.RightValue;
import java.util.ArrayList;
import java.util.List;

public class CommandSelect
extends AbstractCommandSelectPart {
    public static final String CASE_APPLIED = "SELECT_CASE_APPLIED";
    private Expression expression;
    private CommandEndSelect commandEndSelect;
    private final List<CommandCase> cases = new ArrayList<CommandCase>();

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public void execute(Interpreter interpreter) throws ScriptBasicException {
        RightValue expressionValue = this.expression.evaluate(interpreter);
        interpreter.getMap().put(CASE_APPLIED, false);
        for (CommandCase singleCase : this.cases) {
            if (!singleCase.matches(interpreter, expressionValue)) continue;
            interpreter.setNextCommand(singleCase);
            return;
        }
        interpreter.setNextCommand(this.commandEndSelect.getNextCommand());
    }

    public void setEndSelectNode(CommandEndSelect commandEndSelect) {
        this.commandEndSelect = commandEndSelect;
        for (CommandCase singleCase : this.cases) {
            singleCase.setEndSelect(commandEndSelect);
        }
    }

    public void registerCase(CommandCase node) {
        this.cases.add(node);
    }
}

