/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.operators;

import com.scriptbasic.executors.operators.AbstractBinaryFullCircuitHalfDoubleOperator;
import com.scriptbasic.executors.rightvalues.BasicBooleanValue;
import com.scriptbasic.executors.rightvalues.BasicDateValue;
import com.scriptbasic.executors.rightvalues.BasicDoubleValue;
import com.scriptbasic.executors.rightvalues.BasicJavaObjectValue;
import com.scriptbasic.executors.rightvalues.BasicLongValue;
import com.scriptbasic.executors.rightvalues.BasicStringValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.spi.RightValue;

public class AddOperator
extends AbstractBinaryFullCircuitHalfDoubleOperator {
    private static String myToString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    private static String getString(RightValue op) throws BasicRuntimeException {
        if (op.isString().booleanValue()) {
            return (String)((BasicStringValue)op).getValue();
        }
        if (op.isDouble().booleanValue()) {
            return AddOperator.myToString(((BasicDoubleValue)op).getValue());
        }
        if (op.isLong().booleanValue()) {
            return AddOperator.myToString(((BasicLongValue)op).getValue());
        }
        if (op.isBoolean().booleanValue()) {
            return AddOperator.myToString(((BasicBooleanValue)op).getValue());
        }
        if (op.isJavaObject().booleanValue()) {
            return AddOperator.myToString(((BasicJavaObjectValue)op).getValue());
        }
        throw new BasicRuntimeException("Argument can not be converted to string");
    }

    @Override
    protected RightValue operateOnDoubleDouble(Double a, Double b) {
        return new BasicDoubleValue(a + b);
    }

    @Override
    protected RightValue operateOnLongLong(Long a, Long b) {
        return new BasicLongValue(a + b);
    }

    @Override
    protected RightValue operateOnValues(RightValue leftOperand, RightValue rightOperand) throws BasicRuntimeException {
        return new BasicStringValue(AddOperator.getString(leftOperand) + AddOperator.getString(rightOperand));
    }

    @Override
    protected String operatorName() {
        return "Plus";
    }

    @Override
    protected RightValue operateOnDate(Long a, Long b) {
        return BasicDateValue.fromLong(a + b);
    }
}

