/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.executors.rightvalues.AbstractNumericRightValue;
import com.scriptbasic.executors.rightvalues.AbstractPrimitiveRightValue;
import com.scriptbasic.executors.rightvalues.BasicEmptyValue;
import com.scriptbasic.executors.rightvalues.BasicJavaObjectValue;
import com.scriptbasic.executors.rightvalues.BasicStringValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.spi.RightValue;

public final class BasicBooleanValue
extends AbstractPrimitiveRightValue<Boolean> {
    public BasicBooleanValue(Boolean b) {
        this.setValue(b);
    }

    private static Boolean convertNumeric(AbstractNumericRightValue<Number, Object> originalValue) {
        Double d;
        Long l;
        Boolean convertedValue = originalValue.isLong() != false ? Boolean.valueOf((l = (Long)originalValue.getValue()) != null && l != 0L) : (originalValue.isDouble() != false ? Boolean.valueOf((d = (Double)originalValue.getValue()) != null && d != 0.0) : null);
        return convertedValue;
    }

    public static Boolean asBoolean(RightValue originalValue) throws BasicRuntimeException {
        Boolean convertedValue;
        if (originalValue == null || originalValue == BasicEmptyValue.EMPTY_VALUE) {
            convertedValue = Boolean.FALSE;
        } else if (originalValue instanceof AbstractNumericRightValue) {
            convertedValue = BasicBooleanValue.convertNumeric((AbstractNumericRightValue)originalValue);
        } else if (originalValue.isBoolean().booleanValue()) {
            convertedValue = (Boolean)((BasicBooleanValue)originalValue).getValue();
        } else if (originalValue.isString().booleanValue()) {
            String s = (String)((BasicStringValue)originalValue).getValue();
            convertedValue = s != null && s.length() > 0;
        } else if (originalValue.isJavaObject().booleanValue()) {
            Object o = ((BasicJavaObjectValue)originalValue).getValue();
            convertedValue = o instanceof Boolean ? (Boolean)o : Boolean.valueOf(o != null);
        } else {
            throw new BasicRuntimeException("Can not convert value to boolean");
        }
        return convertedValue;
    }

    public String toString() {
        return ((Boolean)this.getValue()).toString();
    }
}

