/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.agent.processors;

import com.securenative.agent.actions.Action;
import com.securenative.agent.processors.BlacklistIp;
import com.securenative.agent.processors.BlockRequest;
import com.securenative.agent.processors.ChallengeRequest;
import com.securenative.agent.processors.DeleteBlacklistedIp;
import com.securenative.agent.processors.DeleteHeaders;
import com.securenative.agent.processors.ModifyHeaders;
import com.securenative.agent.processors.Processor;
import com.securenative.agent.processors.ProcessorType;
import com.securenative.agent.processors.WhitelistIp;
import com.securenative.agent.rules.Rule;

public class ProcessorsFactory {
    public static Processor getRuleProcessor(String processor, Rule rule) {
        if (processor.equals(ProcessorType.DELETE_HEADERS.getType())) {
            return new DeleteHeaders(rule);
        }
        if (processor.equals(ProcessorType.MODIFY_HEADERS.getType())) {
            return new ModifyHeaders(rule);
        }
        if (processor.equals(ProcessorType.BLOCK_REQUEST.getType())) {
            return new BlockRequest();
        }
        if (processor.equals(ProcessorType.CHALLENGE_REQUEST.getType())) {
            return new ChallengeRequest();
        }
        return new Processor();
    }

    public static Processor getActionProcessor(String processor, Action action) {
        if (processor.equals(ProcessorType.BLACKLIST_IP.getType())) {
            return new BlacklistIp(action);
        }
        if (processor.equals(ProcessorType.DELETE_BLACKLISTED.getType())) {
            return new DeleteBlacklistedIp(action);
        }
        if (processor.equals(ProcessorType.WHITELIST_IP.getType())) {
            return new WhitelistIp(action);
        }
        return new Processor();
    }
}

