/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.spring;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.securenative.models.ClientFingerPrint;
import com.securenative.models.Device;
import com.securenative.models.Event;
import com.securenative.models.EventTypes;
import com.securenative.models.SnEvent;
import com.securenative.models.User;
import com.securenative.snlogic.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VerifyWebHookMiddleware
implements Filter {
    private String apikey;
    private Utils utils;
    private final String EMPTY = "";
    private final String SINATURE_KEY = "x-securenative";
    private ObjectMapper mapper;

    public VerifyWebHookMiddleware(String apiKey) {
        this.apikey = apiKey;
        this.utils = new Utils();
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String payload;
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        String signature = "";
        if (req != null && !this.utils.isNullOrEmpty(req.getHeader("x-securenative"))) {
            signature = req.getHeader("x-securenative");
        }
        if (this.utils.isVerifiedSnRequest(payload = this.getBody(servletRequest), signature, this.apikey)) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        res.sendError(401, "Unauthorized");
    }

    public void destroy() {
    }

    private String getBody(ServletRequest servletRequest) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = servletRequest.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String getCookie(HttpServletRequest request, String cookieName) {
        if (request == null || request.getCookies() == null || request.getCookies().length == 0) {
            return null;
        }
        Optional<Cookie> cookie = Arrays.stream(request.getCookies()).filter(x -> (this.utils.isNullOrEmpty(cookieName) ? this.utils.COOKIE_NAME : cookieName).equals(x.getName())).findFirst();
        return cookie.isPresent() ? cookie.get().getValue() : null;
    }

    public String remoteIpFromServletRequest(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        return this.utils.remoteIpFromRequest(arg_0 -> ((HttpServletRequest)request).getHeader(arg_0));
    }

    public Event buildEventFromHttpServletRequest(HttpServletRequest request, Event event) {
        String string;
        String string2;
        String encodedCookie = this.getCookie(request, event != null && !this.utils.isNullOrEmpty(event.getCookieName()) ? event.getCookieName() : this.utils.COOKIE_NAME);
        encodedCookie = this.utils.isNullOrEmpty(encodedCookie) && !this.utils.isNullOrEmpty(event.getCookieValue()) ? event.getCookieValue() : encodedCookie;
        String decodedCookie = "";
        ClientFingerPrint clientFingerPrint = new ClientFingerPrint("", "");
        try {
            decodedCookie = this.utils.decryptAES(encodedCookie, this.apikey);
            clientFingerPrint = (ClientFingerPrint)this.mapper.readValue(decodedCookie, ClientFingerPrint.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String eventype = event == null || this.utils.isNullOrEmpty(event.getEventType()) ? EventTypes.LOG_IN.getType() : event.getEventType();
        String ip = event != null && event.getIp() != null ? event.getIp() : this.remoteIpFromServletRequest(request);
        String remoteIP = request.getRemoteAddr();
        if (event != null && event.getUserAgent() != null) {
            string2 = event.getUserAgent();
        } else {
            this.utils.getClass();
            string2 = request.getHeader("user-agent");
        }
        String userAgent = string2;
        User user = event != null && event.getUser() != null ? event.getUser() : new User(null, null, "anonymous");
        Device device = event != null && event.getDevice() != null ? event.getDevice() : null;
        SnEvent.EventBuilder eventBuilder = new SnEvent.EventBuilder(eventype);
        if (this.utils.isNullOrEmpty(decodedCookie)) {
            this.utils.getClass();
            string = request.getHeader("x-securenative");
        } else {
            string = encodedCookie;
        }
        return eventBuilder.withCookieValue(string).withIp(ip).withRemoteIP(remoteIP).withUserAgent(userAgent).withUser(user).withDevice(device).withCid(clientFingerPrint.getCid()).withFp(clientFingerPrint.getFp()).build();
    }
}

