/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.demo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.selectdb.load.SelectdbClient;
import com.selectdb.load.async.SelectdbAsyncClient;
import com.selectdb.model.BaseResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.UUID;

public class StageLoadAsyncDemo {
    public static void main(String[] args) throws JsonProcessingException {
        StageLoadAsyncDemo.jsonClient();
    }

    public static void jsonListClient() throws JsonProcessingException {
        SelectdbAsyncClient client = SelectdbAsyncClient.builder().setHost("127.0.0.1").setHttpPort(52710).setJdbcPort(21477).setDatabase("wd_test").setTable("test_flink").setClusterName("lh_test").setUsername("admin").setPassword("test_123").addProperty("file.type", "json").addProperty("file.strip_outer_array", "false").addProperty("copy.async", "false").setBufferFlushMaxBytes(1024).setBufferFlushMaxRows(100).setBufferFlushIntervalMs(5000L).build();
        ArrayList<User> data = new ArrayList<User>();
        User user1 = new User();
        user1.name = "zhangsan";
        user1.age = 1;
        User user2 = new User();
        user2.name = "lisi";
        user2.age = 2;
        data.add(user1);
        data.add(user2);
        for (int i = 1; i < 1000; ++i) {
            client.writeRows(new ArrayList(data));
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        client.flush();
        client.close();
    }

    public static void jsonClient() throws JsonProcessingException {
        SelectdbAsyncClient.Builder clientBuilder = SelectdbAsyncClient.builder().setHost("127.0.0.1").setHttpPort(52710).setJdbcPort(21477).setDatabase("wd_test").setTable("test_flink").setClusterName("lh_test").setUsername("admin").setPassword("test_123").addProperty("file.type", "json").addProperty("file.strip_outer_array", "false").addProperty("copy.async", "false").setBufferFlushMaxBytes(102400).setBufferFlushMaxRows(1000).setBufferFlushIntervalMs(10000L).setRetryCount(2).setRetrySleepMs(1000L);
        ObjectMapper objectMapper = new ObjectMapper();
        SelectdbAsyncClient client = clientBuilder.build();
        for (int i = 0; i < 1000; ++i) {
            User user = new User();
            user.name = UUID.randomUUID().toString();
            user.age = 1;
            client.writeRow(objectMapper.writeValueAsString((Object)user).getBytes(StandardCharsets.UTF_8));
        }
        ArrayList<User> list = new ArrayList<User>();
        for (int i = 0; i < 1000; ++i) {
            User user = new User();
            user.name = UUID.randomUUID().toString();
            user.age = 1;
            list.add(user);
        }
        client.writeRows(list);
        client.flush();
        client.close();
    }

    public static void csvClient() throws JsonProcessingException {
        SelectdbClient client = SelectdbClient.builder().setHost("127.0.0.1").setHttpPort(52710).setJdbcPort(21477).setDatabase("wd_test").setTable("test_flink").setClusterName("lh_test").setUsername("admin").setPassword("test_123").addProperty("file.type", "csv").addProperty("file.column_separator", ",").addProperty("file.line_delimiter", "\n").addProperty("copy.async", "false").build();
        String value = "zhangsan,3\nlisi,4";
        BaseResponse response = client.stageLoad(value.getBytes(StandardCharsets.UTF_8));
        System.out.println(new ObjectMapper().writeValueAsString((Object)response));
        BaseResponse response2 = client.stageLoad(value, "file02.csv");
        System.out.println(new ObjectMapper().writeValueAsString((Object)response2));
        BaseResponse response3 = client.stageLoad(value, "file01.csv", "wd_test.test_flink_1");
        System.out.println(new ObjectMapper().writeValueAsString((Object)response3));
    }

    static class User {
        public String name;
        public int age;

        User() {
        }
    }
}

