/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.load;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.selectdb.exceptions.CopyIntoException;
import com.selectdb.load.HttpPostBuilder;
import com.selectdb.load.HttpUtil;
import com.selectdb.load.LoadOptions;
import com.selectdb.model.BaseResponse;
import com.selectdb.model.CopyIntoResp;
import com.selectdb.model.CopyIntoResult;
import com.selectdb.utils.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CopyExecutor.class);
    private static final String COPY_URL_PATTERN = "http://%s:%s/copy/query";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final Pattern COMMITTED_PATTERN = Pattern.compile("errCode = 2, detailMessage = No files can be copied.*");
    public static final int EXEC_SUCCESS = 0;
    private String copyUrl;
    private String clusterName;
    private String username;
    private String password;
    private String tableIdentifier;
    private Map<String, String> properties;
    private HttpClientBuilder httpClientBuilder = new HttpUtil().getHttpClientBuilder();
    private final int retryCount;
    private final long retrySleepMs;

    public CopyExecutor(LoadOptions options) {
        if (options.getDatabase() != null && options.getTable() != null) {
            this.tableIdentifier = options.getDatabase() + "." + options.getTable();
        }
        this.properties = options.getPropertyMap();
        this.copyUrl = String.format(COPY_URL_PATTERN, options.getHost(), options.getHttpPort());
        this.username = options.getUsername();
        this.password = options.getPassword();
        this.clusterName = options.getClusterName();
        this.retryCount = options.getRetryCount();
        this.retrySleepMs = options.getRetrySleepMs();
    }

    public BaseResponse execute(String fileName) throws CopyIntoException {
        String sql = this.buildCopySQL(fileName);
        BaseResponse copyResp = this.executeCopy(sql);
        return copyResp;
    }

    public String buildCopySQL(String file) {
        Preconditions.checkNotNullOrEmpty(this.tableIdentifier, "Please specify the table name to write.");
        StringBuilder sb = new StringBuilder();
        sb.append("COPY INTO ").append(this.tableIdentifier).append(" FROM @~('{").append(file).append("}') ").append("PROPERTIES (");
        StringJoiner props = new StringJoiner(",");
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String prop = String.format("'%s'='%s'", entry.getKey(), entry.getValue());
            props.add(prop);
        }
        sb.append(props).append(")");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseResponse executeCopy(String sql) throws CopyIntoException {
        BaseResponse copyResp = null;
        LOG.info("commit to cluster {} with copy into sql: {}", (Object)this.clusterName, (Object)sql);
        int statusCode = -1;
        String reasonPhrase = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cluster", this.clusterName);
        params.put("sql", sql);
        String loadResult = "";
        int retry = 0;
        while (retry++ <= this.retryCount) {
            HttpPostBuilder postBuilder = new HttpPostBuilder();
            try {
                postBuilder.setUrl(this.copyUrl).baseAuth(this.username, this.password).setEntity((HttpEntity)new StringEntity(OBJECT_MAPPER.writeValueAsString(params)));
                try (CloseableHttpResponse response = this.httpClientBuilder.build().execute((HttpUriRequest)postBuilder.build());){
                    statusCode = response.getStatusLine().getStatusCode();
                    reasonPhrase = response.getStatusLine().getReasonPhrase();
                    if (statusCode != 200) {
                        LOG.error("copy into failed with status {}, reason {}", (Object)statusCode, (Object)reasonPhrase);
                        copyResp = BaseResponse.fail(statusCode, "execute copy into api failed, reason " + reasonPhrase);
                    } else if (response.getEntity() != null && BaseResponse.isSuccess(copyResp = this.handleCommitResponse(loadResult = EntityUtils.toString((HttpEntity)response.getEntity())))) {
                        BaseResponse baseResponse = copyResp;
                        return baseResponse;
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Execute copy into error,", (Throwable)e);
                copyResp = BaseResponse.fail(statusCode, "execute copy into api failed");
            }
            try {
                Thread.sleep(this.retrySleepMs);
            }
            catch (InterruptedException interruptedException) {}
        }
        return copyResp;
    }

    private BaseResponse handleCommitResponse(String loadResult) throws CopyIntoException {
        BaseResponse baseResponse = null;
        try {
            baseResponse = (BaseResponse)OBJECT_MAPPER.readValue(loadResult, BaseResponse.class);
        }
        catch (JsonProcessingException e) {
            LOG.error("parse copy into response failed, result: {}", (Object)loadResult, (Object)e);
            return BaseResponse.fail(-1, "parse copy into response failed");
        }
        if (baseResponse.getCode() == 0) {
            if (baseResponse.getData() instanceof Map) {
                CopyIntoResp dataResp = (CopyIntoResp)OBJECT_MAPPER.convertValue(baseResponse.getData(), CopyIntoResp.class);
                CopyIntoResult result = dataResp.getResult();
                if (!"FINISHED".equals(result.getState()) && !this.isCommitted(result.getMsg())) {
                    LOG.error("copy into load failed, reason:{}", (Object)loadResult);
                } else {
                    LOG.info("commit success, response:{}", (Object)loadResult);
                }
                baseResponse.setData(dataResp);
            }
        } else {
            LOG.error("commit failed, reason:{}", (Object)loadResult);
        }
        return baseResponse;
    }

    private boolean isCommitted(String msg) {
        return COMMITTED_PATTERN.matcher(msg).matches();
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    public void setTableIdentifier(String tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
    }
}

