/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.load;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.selectdb.exceptions.CopyIntoException;
import com.selectdb.exceptions.ParseDataException;
import com.selectdb.exceptions.UploadException;
import com.selectdb.load.CopyExecutor;
import com.selectdb.load.LoadOptions;
import com.selectdb.load.StageLoad;
import com.selectdb.model.BaseResponse;
import com.selectdb.model.CopyIntoResp;
import com.selectdb.model.StageLoadResult;
import com.selectdb.utils.Preconditions;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;

public class SelectdbClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final LoadOptions loadOptions;
    private final String fieldDelimiter;
    private final String lineDelimiter;
    private StageLoad stageLoad;
    private CopyExecutor copyExecutor;

    public SelectdbClient(LoadOptions options) {
        this.loadOptions = options;
        this.fieldDelimiter = options.getPropertyMap().getOrDefault("file.column_separator", "\t");
        this.lineDelimiter = options.getPropertyMap().getOrDefault("file.line_delimiter", "\n");
        this.stageLoad = new StageLoad(options);
        this.copyExecutor = new CopyExecutor(options);
    }

    public BaseResponse stageLoad(byte[] data, String fileName, String tableIdentifier) throws UploadException, CopyIntoException {
        if (tableIdentifier != null && !tableIdentifier.isEmpty()) {
            this.copyExecutor.setTableIdentifier(tableIdentifier);
        }
        this.stageLoad.uploadToStorage(fileName, data);
        BaseResponse copyResp = this.copyExecutor.execute(fileName);
        return this.transformResult(copyResp);
    }

    public BaseResponse stageLoad(byte[] data, String fileName) throws UploadException, CopyIntoException {
        return this.stageLoad(data, fileName, null);
    }

    public BaseResponse stageLoad(byte[] data) throws UploadException, CopyIntoException {
        return this.stageLoad(data, UUID.randomUUID().toString());
    }

    public BaseResponse stageLoad(String data) throws UploadException, CopyIntoException {
        return this.stageLoad(data, UUID.randomUUID().toString());
    }

    public BaseResponse stageLoad(String data, String fileName) throws UploadException, CopyIntoException {
        return this.stageLoad(data, fileName, null);
    }

    public BaseResponse stageLoad(String data, String fileName, String tableIdentifier) throws UploadException, CopyIntoException {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        data = null;
        return this.stageLoad(bytes, fileName, tableIdentifier);
    }

    public <T> BaseResponse stageLoad(List<T> dataList, String fileName, String tableIdentifier) throws UploadException, CopyIntoException {
        StringJoiner rows = new StringJoiner(this.lineDelimiter);
        try {
            for (int index = 0; index < dataList.size(); ++index) {
                T item = dataList.get(index);
                rows.add(OBJECT_MAPPER.writeValueAsString(item));
                dataList.set(index, null);
            }
        }
        catch (JsonProcessingException e) {
            throw new ParseDataException("Parsed error, data converted to json string failed.");
        }
        return this.stageLoad(rows.toString(), fileName, tableIdentifier);
    }

    public <T> BaseResponse stageLoad(List<T> dataList) throws UploadException, CopyIntoException {
        return this.stageLoad(dataList, UUID.randomUUID().toString());
    }

    public <T> BaseResponse stageLoad(List<T> dataList, String fileName) throws UploadException, CopyIntoException {
        return this.stageLoad(dataList, fileName, null);
    }

    public BaseResponse transformResult(BaseResponse copyResp) {
        BaseResponse<StageLoadResult> result = new BaseResponse<StageLoadResult>();
        result.setCode(copyResp.getCode());
        result.setMsg(copyResp.getMsg());
        StageLoadResult loadResult = new StageLoadResult();
        if (copyResp.getData() != null && copyResp.getData() instanceof CopyIntoResp) {
            loadResult.transform((CopyIntoResp)copyResp.getData());
            result.setData(loadResult);
        } else {
            result.setData((StageLoadResult)copyResp.getData());
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String host;
        private int jdbcPort;
        private int httpPort;
        private String clusterName;
        private String username;
        private String password;
        private String database;
        private String table;
        private Map<String, String> propertyMap = new HashMap<String, String>();

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setJdbcPort(int jdbcPort) {
            this.jdbcPort = jdbcPort;
            return this;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public Builder setClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder setHttpPort(int httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder addProperties(Map<String, String> properties) {
            if (properties != null) {
                this.propertyMap.putAll(properties);
            }
            return this;
        }

        public Builder addProperty(String key, String value) {
            if (key != null) {
                this.propertyMap.put(key, value);
            }
            return this;
        }

        public SelectdbClient build() {
            Preconditions.checkNotNullOrEmpty(this.host, "host is required");
            Preconditions.checkNotNull(this.jdbcPort);
            Preconditions.checkNotNull(this.httpPort);
            Preconditions.checkNotNullOrEmpty(this.clusterName, "cluster name is required");
            Preconditions.checkNotNullOrEmpty(this.username, "username is required");
            LoadOptions options = new LoadOptions(this.host, this.jdbcPort, this.httpPort, this.clusterName, this.username, this.password, this.database, this.table, this.propertyMap);
            return new SelectdbClient(options);
        }
    }
}

