/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.load;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.selectdb.exceptions.UploadException;
import com.selectdb.load.HttpPutBuilder;
import com.selectdb.load.HttpUtil;
import com.selectdb.load.LoadOptions;
import com.selectdb.load.async.RecordBuffer;
import com.selectdb.utils.BackoffAndRetryUtils;
import com.selectdb.utils.Preconditions;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageLoad
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(StageLoad.class);
    private static final String UPLOAD_URL_PATTERN = "http://%s:%s/copy/upload";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String uploadUrl;
    private String username;
    private String password;
    private HttpClientBuilder httpClientBuilder = new HttpUtil().getHttpClientBuilder();
    private final BackoffAndRetryUtils backoffAndRetryUtils;

    public StageLoad(LoadOptions options) {
        this.uploadUrl = String.format(UPLOAD_URL_PATTERN, options.getHost(), options.getHttpPort());
        this.username = options.getUsername();
        this.password = options.getPassword();
        this.backoffAndRetryUtils = new BackoffAndRetryUtils(options.getRetryCount(), options.getRetrySleepMs());
    }

    public void uploadToStorage(String fileName, byte[] data) throws UploadException {
        long start = System.currentTimeMillis();
        LOG.info("file write started for {}", (Object)fileName);
        String address = this.getUploadAddress(fileName);
        long addressTs = System.currentTimeMillis();
        LOG.info("redirect to internalStage address:{}, cost {} ms", (Object)address, (Object)(addressTs - start));
        String requestId = this.uploadToInternalStage(address, data);
        LOG.info("upload file {} finished, size {}, cost {}ms, with requestId {}", new Object[]{fileName, data.length, System.currentTimeMillis() - addressTs, requestId});
    }

    public void uploadToStorage(String fileName, RecordBuffer buffer) throws UploadException {
        long start = System.currentTimeMillis();
        LOG.info("file write started for {}", (Object)fileName);
        String address = this.getUploadAddress(fileName);
        long addressTs = System.currentTimeMillis();
        LOG.info("redirect to internalStage address:{}, cost {} ms", (Object)address, (Object)(addressTs - start));
        String requestId = this.uploadToInternalStage(address, buffer.getData());
        LOG.info("upload file {} finished, record {} size {}, cost {}ms, with requestId {}", new Object[]{fileName, buffer.getNumOfRecords(), buffer.getBufferSizeBytes(), System.currentTimeMillis() - addressTs, requestId});
    }

    public String uploadToInternalStage(String address, byte[] data) throws UploadException {
        ByteArrayEntity entity = new ByteArrayEntity(data);
        return this.uploadToInternalStage(address, entity);
    }

    public String uploadToInternalStage(String address, ByteBuffer data) {
        ByteArrayEntity entity = new ByteArrayEntity(data.array(), data.arrayOffset(), data.limit());
        return this.uploadToInternalStage(address, entity);
    }

    private String uploadToInternalStage(String address, ByteArrayEntity entity) {
        HttpPutBuilder putBuilder = new HttpPutBuilder();
        putBuilder.setUrl(address).addCommonHeader().setEntity((HttpEntity)entity);
        HttpPut httpPut = putBuilder.build();
        try {
            Object result = this.backoffAndRetryUtils.backoffAndRetry(BackoffAndRetryUtils.LoadOperation.UPLOAD_FILE, () -> {
                Throwable throwable = null;
                try (CloseableHttpResponse response = this.httpClientBuilder.build().execute((HttpUriRequest)httpPut);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    String requestId = this.getRequestId(response.getAllHeaders());
                    if (statusCode != 200 || response.getEntity() == null) throw new UploadException("upload file error: " + response.getStatusLine().toString() + ", with requestId " + requestId);
                    String loadResult = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (loadResult == null || loadResult.isEmpty()) {
                        String string = requestId;
                        return string;
                    }
                    try {
                        LOG.error("upload file failed, requestId is {}, response result: {}", (Object)requestId, (Object)loadResult);
                        throw new UploadException("upload file failed: " + response.getStatusLine().toString() + ", with requestId " + requestId);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            });
            return String.valueOf(result);
        }
        catch (Exception ex) {
            LOG.error("Failed to upload data to internal stage ", (Throwable)ex);
            throw new UploadException("Failed to upload data to internal stage, " + ex.getMessage());
        }
    }

    public String getRequestId(Header[] headers) {
        if (headers == null || headers.length == 0) {
            return null;
        }
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            String name = header.getName();
            if (name == null || !name.toLowerCase().matches("x-\\S+-request-id")) continue;
            return name + ":" + header.getValue();
        }
        return null;
    }

    public String getUploadAddress(String fileName) throws UploadException {
        HttpPutBuilder putBuilder = new HttpPutBuilder();
        putBuilder.setUrl(this.uploadUrl).addFileName(fileName).addCommonHeader().setEmptyEntity().baseAuth(this.username, this.password);
        try {
            Object address = this.backoffAndRetryUtils.backoffAndRetry(BackoffAndRetryUtils.LoadOperation.GET_INTERNAL_STAGE_ADDRESS, () -> {
                Throwable throwable = null;
                try (CloseableHttpResponse execute = this.httpClientBuilder.build().execute((HttpUriRequest)putBuilder.build());){
                    int statusCode = execute.getStatusLine().getStatusCode();
                    String reason = execute.getStatusLine().getReasonPhrase();
                    if (statusCode == 307) {
                        String uploadAddress;
                        Header location = execute.getFirstHeader("location");
                        String string = uploadAddress = location.getValue();
                        return string;
                    }
                    try {
                        HttpEntity entity = execute.getEntity();
                        String result = entity == null ? null : EntityUtils.toString((HttpEntity)entity);
                        LOG.error("Failed to get internalStage address, status {}, reason {}, response {}", new Object[]{statusCode, reason, result});
                        throw new UploadException("Failed get internalStage address");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            });
            Preconditions.checkNotNull(address, "internalStage address is null");
            return address.toString();
        }
        catch (Exception e) {
            LOG.error("Get internalStage address error,", (Throwable)e);
            throw new UploadException("Get internalStage address error, " + e.getMessage());
        }
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

