/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.load.async;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(RecordBuffer.class);
    public static final String LINE_SEPARATOR = "\n";
    private String fileName;
    private ByteBuffer buffer;
    private byte[] lineDelimiter;
    private int numOfRecords = 0;
    private int bufferSizeBytes = 0;
    private boolean loadBatchFirstRecord = true;

    public RecordBuffer() {
    }

    public RecordBuffer(byte[] lineDelimiter, int bufferSize) {
        this.lineDelimiter = lineDelimiter;
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    public void insert(byte[] record) {
        this.ensureCapacity(record.length);
        if (this.loadBatchFirstRecord) {
            this.loadBatchFirstRecord = false;
        } else {
            this.buffer.put(this.lineDelimiter);
        }
        this.buffer.put(record);
        this.setNumOfRecords(this.getNumOfRecords() + 1);
        this.setBufferSizeBytes(this.getBufferSizeBytes() + record.length);
    }

    public void ensureCapacity(int length) {
        if (this.buffer.remaining() >= length) {
            return;
        }
        int currentRemain = this.buffer.remaining();
        int currentCapacity = this.buffer.capacity();
        int target = this.buffer.remaining() + length;
        int capacity = this.buffer.capacity();
        target = Math.max(target, Math.min(capacity + 524288, capacity * 2));
        ByteBuffer tmp = ByteBuffer.allocate(target);
        this.buffer.flip();
        tmp.put(this.buffer);
        this.buffer.clear();
        this.buffer = tmp;
        LOG.info("record length {},buffer remain {} ,grow capacity {} to {}", new Object[]{length, currentRemain, currentCapacity, target});
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isEmpty() {
        return this.numOfRecords == 0;
    }

    public ByteBuffer getData() {
        this.buffer.flip();
        LOG.debug("flush buffer: {} records, {} bytes", (Object)this.getNumOfRecords(), (Object)this.getBufferSizeBytes());
        return this.buffer;
    }

    public void clear() {
        this.buffer.clear();
        this.numOfRecords = 0;
        this.bufferSizeBytes = 0;
        this.fileName = null;
        this.loadBatchFirstRecord = true;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getNumOfRecords() {
        return this.numOfRecords;
    }

    public int getBufferSizeBytes() {
        return this.bufferSizeBytes;
    }

    public void setNumOfRecords(int numOfRecords) {
        this.numOfRecords = numOfRecords;
    }

    public void setBufferSizeBytes(int bufferSizeBytes) {
        this.bufferSizeBytes = bufferSizeBytes;
    }
}

