/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.load.async;

import com.selectdb.load.LoadOptions;
import com.selectdb.load.async.SelectdbAsyncClientInternal;
import com.selectdb.utils.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface SelectdbAsyncClient {
    public void writeRow(byte[] var1);

    public <T> void writeRows(List<T> var1);

    public void flush();

    public void close();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String host;
        private int jdbcPort;
        private int httpPort;
        private String clusterName;
        private String username;
        private String password;
        private String database;
        private String table;
        private Map<String, String> propertyMap = new HashMap<String, String>();
        private int flushQueueSize = 2;
        private int bufferFlushMaxRows = 10000;
        private int bufferFlushMaxBytes = 0x1000000;
        private long bufferFlushIntervalMs = 10000L;
        private int retryCount = 3;
        private long retrySleepMs = 3000L;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setJdbcPort(int jdbcPort) {
            this.jdbcPort = jdbcPort;
            return this;
        }

        public Builder setClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder setHttpPort(int httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setFlushQueueSize(int flushQueueSize) {
            this.flushQueueSize = flushQueueSize;
            return this;
        }

        public Builder setBufferFlushMaxRows(int bufferFlushMaxRows) {
            this.bufferFlushMaxRows = bufferFlushMaxRows;
            return this;
        }

        public Builder setBufferFlushMaxBytes(int bufferFlushMaxBytes) {
            this.bufferFlushMaxBytes = bufferFlushMaxBytes;
            return this;
        }

        public Builder setBufferFlushIntervalMs(long bufferFlushIntervalMs) {
            this.bufferFlushIntervalMs = bufferFlushIntervalMs;
            return this;
        }

        public Builder setRetryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public Builder setRetrySleepMs(long retrySleepMs) {
            this.retrySleepMs = retrySleepMs;
            return this;
        }

        public Builder addProperties(Map<String, String> properties) {
            if (properties != null) {
                this.propertyMap.putAll(properties);
            }
            return this;
        }

        public Builder addProperty(String key, String value) {
            if (key != null) {
                this.propertyMap.put(key, value);
            }
            return this;
        }

        public SelectdbAsyncClient build() {
            Preconditions.checkNotNullOrEmpty(this.host, "host is required");
            Preconditions.checkNotNull(this.jdbcPort);
            Preconditions.checkNotNull(this.httpPort);
            Preconditions.checkNotNullOrEmpty(this.clusterName, "cluster name is required");
            Preconditions.checkNotNullOrEmpty(this.username, "username is required");
            LoadOptions options = new LoadOptions(this.host, this.jdbcPort, this.httpPort, this.clusterName, this.username, this.password, this.database, this.table, this.propertyMap, this.flushQueueSize, this.bufferFlushMaxRows, this.bufferFlushMaxBytes, this.bufferFlushIntervalMs, this.retryCount, this.retrySleepMs);
            return new SelectdbAsyncClientInternal(options);
        }
    }
}

