/*
 * Decompiled with CFR 0.152.
 */
package com.selectdb.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.selectdb.load.CopyExecutor;
import com.selectdb.model.CopyIntoResp;
import com.selectdb.model.CopyIntoResult;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaseResponse<T>
implements Serializable {
    private int code;
    private String msg;
    private T data;

    public BaseResponse() {
    }

    public BaseResponse(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static BaseResponse fail(int code, String message) {
        return new BaseResponse(code, message);
    }

    public static boolean isSuccess(BaseResponse response) {
        CopyIntoResp copyResp;
        CopyIntoResult result;
        if (response == null || response.getCode() != 0) {
            return false;
        }
        return response.getData() != null && response.getData() instanceof CopyIntoResp && ("FINISHED".equals((result = (copyResp = (CopyIntoResp)response.getData()).getResult()).getState()) || BaseResponse.isCommitted(result.getMsg()));
    }

    private static boolean isCommitted(String msg) {
        return CopyExecutor.COMMITTED_PATTERN.matcher(msg).matches();
    }

    public String toString() {
        return "BaseResponse{code=" + this.code + ", msg='" + this.msg + '\'' + ", data=" + this.data + '}';
    }
}

