/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk;

import com.shadowvc.sdk.ApiException;
import com.shadowvc.sdk.DefaultEopClient;
import com.shadowvc.sdk.EopRequest;
import com.shadowvc.sdk.EopResponse;

public class AutoRetryEopClient
extends DefaultEopClient {
    private static final ApiException RETRY_FAIL = new ApiException("sdk.retry-call-fail", "API\u8c03\u7528\u91cd\u8bd5\u5931\u8d25");
    private static final ThreadLocal<Long> RETRY_COUNTER = new ThreadLocal();
    private int maxRetryCount = 3;
    private long retryWaitTime = 500L;
    private boolean throwIfOverMaxRetry = false;

    public AutoRetryEopClient(String serverUrl, String appKey, String appSecret) {
        super(serverUrl, appKey, appSecret);
    }

    public AutoRetryEopClient(String serverUrl, String appKey, String appSecret, String format) {
        super(serverUrl, appKey, appSecret, format);
    }

    public AutoRetryEopClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        super(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
    }

    public AutoRetryEopClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        super(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout, signMethod);
    }

    @Override
    public <T extends EopResponse> T execute(EopRequest<T> request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends EopResponse> T execute(EopRequest<T> request, String session) throws ApiException {
        EopResponse rsp = null;
        try {
            RETRY_COUNTER.set(this.getCurrentRetryCount() + 1L);
            rsp = (EopResponse)super.execute(request, session);
            if (!rsp.isSuccess()) {
                if (this.getCurrentRetryCount() < (long)this.maxRetryCount) {
                    if (rsp.getSubCode() != null && rsp.getSubCode().startsWith("isp.")) {
                        this.sleepWithoutInterrupt(this.retryWaitTime);
                        T t = this.execute(request, session);
                        return t;
                    }
                } else if (this.throwIfOverMaxRetry) {
                    throw RETRY_FAIL;
                }
            }
        }
        catch (ApiException e) {
            if (e != RETRY_FAIL && this.getCurrentRetryCount() < (long)this.maxRetryCount) {
                this.sleepWithoutInterrupt(this.retryWaitTime);
                T t = this.execute(request, session);
                return t;
            }
            throw e;
        }
        finally {
            RETRY_COUNTER.set(null);
        }
        return (T)rsp;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public void setRetryWaitTime(long retryWaitTime) {
        this.retryWaitTime = retryWaitTime;
    }

    public void setThrowIfOverMaxRetry(boolean throwIfOverMaxRetry) {
        this.throwIfOverMaxRetry = throwIfOverMaxRetry;
    }

    private Long getCurrentRetryCount() {
        if (RETRY_COUNTER.get() == null) {
            return -1L;
        }
        return RETRY_COUNTER.get();
    }

    private void sleepWithoutInterrupt(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

