/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk;

import com.shadowvc.sdk.ApiException;
import com.shadowvc.sdk.ApiRuleException;
import com.shadowvc.sdk.EopClient;
import com.shadowvc.sdk.EopHashMap;
import com.shadowvc.sdk.EopLogger;
import com.shadowvc.sdk.EopParser;
import com.shadowvc.sdk.EopRequest;
import com.shadowvc.sdk.EopResponse;
import com.shadowvc.sdk.EopUploadRequest;
import com.shadowvc.sdk.EopUtils;
import com.shadowvc.sdk.internal.parser.ObjectJsonParser;
import com.shadowvc.sdk.internal.util.FileItem;
import com.shadowvc.sdk.internal.util.RequestParamHolder;
import com.shadowvc.sdk.internal.util.WebUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class DefaultEopClient
implements EopClient {
    private static final String APP_KEY = "appKey";
    private static final String FORMAT = "format";
    private static final String METHOD = "method";
    private static final String TIMESTAMP = "timestamp";
    private static final String VERSION = "v";
    private static final String SIGN = "sign";
    private static final String SIGN_METHOD = "signMethod";
    private static final String SDK_VERSION = "sdkVersion";
    private static final String ACCESS_KEY = "accessKey";
    private String serverUrl;
    private String appKey;
    private String appSecret;
    private String format = "json";
    private String signMethod = "md5";
    private int connectTimeout = 3000;
    private int readTimeout = 15000;
    private boolean needCheckRequest = true;
    private boolean needEnableParser = true;

    public DefaultEopClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    public DefaultEopClient(String serverUrl, String appKey, String appSecret, String format) {
        this(serverUrl, appKey, appSecret);
        this.format = format;
    }

    public DefaultEopClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultEopClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        this(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
        this.signMethod = signMethod;
    }

    @Override
    public <T extends EopResponse> T execute(EopRequest<T> request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends EopResponse> T execute(EopRequest<T> request, String accessKey) throws ApiException {
        ObjectJsonParser<T> parser = null;
        if (this.needEnableParser) {
            parser = new ObjectJsonParser<T>(request.getResponseClass());
        }
        return this._execute(request, parser, accessKey);
    }

    private <T extends EopResponse> T _execute(EopRequest<T> request, EopParser<T> parser, String accessKey) throws ApiException {
        Map<String, Object> rt;
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                EopResponse localResponse = null;
                try {
                    localResponse = (EopResponse)request.getResponseClass().newInstance();
                }
                catch (InstantiationException e2) {
                    throw new ApiException(e2);
                }
                catch (IllegalAccessException e3) {
                    throw new ApiException(e3);
                }
                localResponse.setErrorCode(e.getErrCode());
                localResponse.setMsg(e.getErrMsg());
                return (T)localResponse;
            }
        }
        if ((rt = this.doPost(request, accessKey)) == null) {
            return null;
        }
        EopResponse tRsp = null;
        if (this.needEnableParser) {
            try {
                tRsp = parser.parse((String)rt.get("rsp"));
                tRsp.setResponseBody((String)rt.get("rsp"));
            }
            catch (RuntimeException e) {
                EopLogger.logBizError((String)rt.get("rsp"));
                throw e;
            }
        }
        try {
            tRsp = (EopResponse)request.getResponseClass().newInstance();
            tRsp.setResponseBody((String)rt.get("rsp"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        tRsp.setRequestParams((EopHashMap)rt.get("textParams"));
        tRsp.setRequestUrl((String)rt.get("url"));
        if (!tRsp.isSuccess()) {
            EopLogger.logErrorScene(rt, tRsp, this.appSecret);
        }
        return (T)tRsp;
    }

    public <T extends EopResponse> Map<String, Object> doPost(EopRequest<T> request, String accessKey) throws ApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParamHolder requestHolder = new RequestParamHolder();
        EopHashMap appParams = new EopHashMap(request.getTextParams());
        requestHolder.setAppParams(appParams);
        EopHashMap proMustParams = new EopHashMap();
        proMustParams.put(METHOD, request.getApiMethodName());
        proMustParams.put(VERSION, "2.0");
        proMustParams.put(APP_KEY, this.appKey);
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        proMustParams.put(TIMESTAMP, df.format(new Date(timestamp)));
        requestHolder.setProMustParams(proMustParams);
        EopHashMap proOptParams = new EopHashMap();
        proOptParams.put(FORMAT, this.format);
        proOptParams.put(SIGN_METHOD, this.signMethod);
        proOptParams.put(ACCESS_KEY, accessKey);
        proOptParams.put(SDK_VERSION, "eop-sdk-java-20140525");
        requestHolder.setProOptParams(proOptParams);
        try {
            if ("md5".equals(this.signMethod)) {
                proMustParams.put(SIGN, EopUtils.signEopRequestNew(requestHolder, this.appSecret, false));
            } else if ("hmac".equals(this.signMethod)) {
                proMustParams.put(SIGN, EopUtils.signEopRequestNew(requestHolder, this.appSecret, true));
            } else {
                proMustParams.put(SIGN, EopUtils.signEopRequest(requestHolder, this.appSecret));
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        StringBuffer urlSb = new StringBuffer(this.serverUrl);
        try {
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProOptParams(), "UTF-8");
            urlSb.append("?");
            urlSb.append(sysMustQuery);
            if (sysOptQuery != null) {
                urlSb.append("&");
                urlSb.append(sysOptQuery);
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        String rsp = null;
        try {
            if (request instanceof EopUploadRequest) {
                EopUploadRequest uRequest = (EopUploadRequest)request;
                Map<String, FileItem> fileParams = EopUtils.cleanupMap(uRequest.getFileParams());
                rsp = WebUtils.doPost(urlSb.toString(), (Map<String, String>)appParams, fileParams, this.connectTimeout, this.readTimeout);
            } else {
                rsp = WebUtils.doPost(urlSb.toString(), appParams, this.connectTimeout, this.readTimeout);
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        result.put("rsp", rsp);
        result.put("textParams", appParams);
        result.put("protocalMustParams", proMustParams);
        result.put("protocalOptParams", proOptParams);
        result.put("url", urlSb.toString());
        return result;
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        EopLogger.setNeedEnableLogger(needEnableLogger);
    }
}

