/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk;

import com.shadowvc.sdk.ApiException;
import com.shadowvc.sdk.EopHashMap;
import com.shadowvc.sdk.EopResponse;
import com.shadowvc.sdk.internal.parser.ObjectJsonParser;
import com.shadowvc.sdk.internal.util.RequestParamHolder;
import com.shadowvc.sdk.internal.util.StringUtils;
import com.shadowvc.sdk.internal.util.WebUtils;
import com.shadowvc.sdk.internal.util.codec.Base64;
import com.shadowvc.sdk.internal.util.json.JSONReader;
import com.shadowvc.sdk.internal.util.json.JSONValidatingReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class EopUtils {
    private static String localIp;

    private EopUtils() {
    }

    public static String signEopRequest(RequestParamHolder requestHolder, String secret) throws IOException {
        EopHashMap protocalOptParams;
        EopHashMap protocalMustParams;
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        EopHashMap appParams = requestHolder.getAppParams();
        if (appParams != null && appParams.size() > 0) {
            sortedParams.putAll(appParams);
        }
        if ((protocalMustParams = requestHolder.getProMustParams()) != null && protocalMustParams.size() > 0) {
            sortedParams.putAll(protocalMustParams);
        }
        if ((protocalOptParams = requestHolder.getProOptParams()) != null && protocalOptParams.size() > 0) {
            sortedParams.putAll(protocalOptParams);
        }
        Set paramSet = sortedParams.entrySet();
        StringBuilder query = new StringBuilder(secret);
        for (Map.Entry param : paramSet) {
            if (null == param.getValue()) continue;
            query.append((String)param.getKey()).append((String)param.getValue());
        }
        byte[] bytes = EopUtils.encryptMD5(query.toString());
        return EopUtils.byte2hex(bytes);
    }

    public static String signEopRequestNew(RequestParamHolder requestHolder, String secret, boolean isHmac) throws IOException {
        byte[] bytes;
        EopHashMap protocalOptParams;
        EopHashMap protocalMustParams;
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        EopHashMap appParams = requestHolder.getAppParams();
        if (appParams != null && appParams.size() > 0) {
            sortedParams.putAll(appParams);
        }
        if ((protocalMustParams = requestHolder.getProMustParams()) != null && protocalMustParams.size() > 0) {
            sortedParams.putAll(protocalMustParams);
        }
        if ((protocalOptParams = requestHolder.getProOptParams()) != null && protocalOptParams.size() > 0) {
            sortedParams.putAll(protocalOptParams);
        }
        Set paramSet = sortedParams.entrySet();
        StringBuilder query = new StringBuilder();
        if (!isHmac) {
            query.append(secret);
        }
        for (Map.Entry param : paramSet) {
            if (param.getValue() == null) continue;
            query.append((String)param.getKey()).append((String)param.getValue());
        }
        if (isHmac) {
            bytes = EopUtils.encryptHMAC(query.toString(), secret);
        } else {
            query.append(secret);
            bytes = EopUtils.encryptMD5(query.toString());
        }
        return EopUtils.byte2hex(bytes);
    }

    private static byte[] encryptHMAC(String data, String secret) throws IOException {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            String msg = EopUtils.getStringFromException(gse);
            throw new IOException(msg);
        }
        return bytes;
    }

    private static String getStringFromException(Throwable e) {
        String result = "";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        try {
            result = bos.toString("UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static byte[] encryptMD5(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            String msg = EopUtils.getStringFromException(gse);
            throw new IOException(msg);
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static boolean verifyEopResponse(String topParams, String topSession, String topSign, String appKey, String appSecret) throws IOException {
        StringBuilder result = new StringBuilder();
        result.append(appKey).append(topParams).append(topSession).append(appSecret);
        byte[] bytes = EopUtils.encryptMD5(result.toString());
        Base64 encoder = new Base64();
        return new String(encoder.encode(bytes)).equals(topSign);
    }

    public static Map<String, String> decodeEopParams(String topParams) throws IOException {
        return EopUtils.decodeEopParams(topParams, "GBK");
    }

    public static Map<String, String> decodeEopParams(String topParams, String charset) throws IOException {
        if (StringUtils.isEmpty(topParams)) {
            return null;
        }
        Base64 decoder = new Base64();
        byte[] buffer = decoder.decode(WebUtils.decode(topParams).getBytes());
        String originTopParams = new String(buffer, charset);
        return WebUtils.splitUrlQuery(originTopParams);
    }

    public static String getFileSuffix(byte[] bytes) {
        if (bytes == null || bytes.length < 10) {
            return null;
        }
        if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "GIF";
        }
        if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "PNG";
        }
        if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "JPG";
        }
        if (bytes[0] == 66 && bytes[1] == 77) {
            return "BMP";
        }
        return null;
    }

    public static String getMimeType(byte[] bytes) {
        String suffix = EopUtils.getFileSuffix(bytes);
        String mimeType = "JPG".equals(suffix) ? "image/jpeg" : ("GIF".equals(suffix) ? "image/gif" : ("PNG".equals(suffix) ? "image/png" : ("BMP".equals(suffix) ? "image/bmp" : "application/octet-stream")));
        return mimeType;
    }

    public static <V> Map<String, V> cleanupMap(Map<String, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, V> result = new HashMap<String, V>(map.size());
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> entry : entries) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<?, ?> parseJson(String body) {
        JSONValidatingReader jr = new JSONValidatingReader();
        Object obj = ((JSONReader)jr).read(body);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public static <T extends EopResponse> T parseResponse(String json, Class<T> clazz) throws ApiException {
        ObjectJsonParser<T> parser = new ObjectJsonParser<T>(clazz);
        return parser.parse(json);
    }

    public static String getLocalNetWorkIp() {
        if (localIp != null) {
            return localIp;
        }
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                if (ni.isLoopback() || ni.isVirtual()) continue;
                Enumeration<InetAddress> addresss = ni.getInetAddresses();
                while (addresss.hasMoreElements()) {
                    InetAddress address = addresss.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    ip = address;
                    break;
                }
                if (ip == null) continue;
                break;
            }
            localIp = ip != null ? ip.getHostAddress() : "127.0.0.1";
        }
        catch (Exception e) {
            localIp = "127.0.0.1";
        }
        return localIp;
    }
}

