/*
 * Decompiled with CFR 0.152.
 */
package com.shadowvc.sdk.internal.cache;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;

public class ValidateUtil {
    public static boolean isNumberInRange(String text, BigInteger min, BigInteger max) {
        BigInteger value = null;
        try {
            value = new BigInteger(text);
        }
        catch (Exception e) {
            return false;
        }
        if (min != null && value.compareTo(min) < 0) {
            return false;
        }
        return max == null || value.compareTo(max) <= 0;
    }

    public static boolean isBoolean(String input) {
        if (input == null) {
            return false;
        }
        return input.equals("true") || input.equals("false");
    }

    public static boolean isDate(String input) {
        if (input == null) {
            return false;
        }
        try {
            ValidateUtil.ymdOrYmdhms2Date(input);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean isPrice(String input) {
        if (input == null) {
            return false;
        }
        int dotPos = input.indexOf(46);
        if (dotPos == -1) {
            return ValidateUtil.isUnsignedNumber(input);
        }
        if (dotPos + 1 == input.length()) {
            return false;
        }
        String partInteger = input.substring(0, dotPos);
        String partDecimal = input.substring(dotPos + 1, input.length());
        if (partDecimal.length() > 2) {
            return false;
        }
        return ValidateUtil.isUnsignedNumber(partInteger) && ValidateUtil.isUnsignedNumber(partDecimal);
    }

    private static boolean isUnsignedNumber(String text) {
        if (text == null) {
            return false;
        }
        if (text.length() == 0) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static Date ymdOrYmdhms2Date(String str) throws ParseException {
        if (str == null) {
            return null;
        }
        if (str.length() != 10 && str.length() != 19 && str.length() != 23) {
            throw new ParseException("error date:" + str, 0);
        }
        char[] strs = str.toCharArray();
        GregorianCalendar cal = null;
        int year = ValidateUtil.parseInt(strs, 0, 4);
        int month = ValidateUtil.parseInt(strs, 5, 7) - 1;
        int date = ValidateUtil.parseInt(strs, 8, 10);
        if (strs.length >= 19) {
            int hrs = ValidateUtil.parseInt(strs, 11, 13);
            int min = ValidateUtil.parseInt(strs, 14, 16);
            int sec = ValidateUtil.parseInt(strs, 17, 19);
            cal = new GregorianCalendar(year, month, date, hrs, min, sec);
            if (strs.length == 23) {
                int sss = ValidateUtil.parseInt(strs, 20, 23);
                cal.set(14, sss);
            }
        } else {
            cal = new GregorianCalendar(year, month, date);
        }
        return cal.getTime();
    }

    private static int parseInt(char[] strs, int beginindex, int endindex) throws ParseException {
        int result = 0;
        int b = 1;
        for (int i = endindex - 1; i >= beginindex; --i) {
            if (strs[i] < '0' || strs[i] > '9') {
                throw new ParseException("Parse error,can't parse char to int . ", 0);
            }
            result += (strs[i] - 48) * b;
            b *= 10;
        }
        return result;
    }
}

